/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.content.web.internal.portlet;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.model.AssetEntryUsage;
import com.liferay.asset.service.AssetEntryUsageLocalService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalContentSearchLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.AddPortletProvider;
import com.liferay.portal.kernel.portlet.BasePortletProvider;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.journal.model.JournalArticle"}, service={AddPortletProvider.class})
public class JournalContentAddPortletProvider
extends BasePortletProvider
implements AddPortletProvider {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetEntryUsageLocalService _assetEntryUsageLocalService;
    @Reference
    private JournalContentSearchLocalService _journalContentSearchLocal;
    @Reference
    private Portal _portal;

    public String getPortletName() {
        return "com_liferay_journal_content_web_portlet_JournalContentPortlet";
    }

    public PortletURL getPortletURL(HttpServletRequest httpServletRequest, Group group) throws PortalException {
        return PortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest, (String)this.getPortletName(), (String)"RENDER_PHASE");
    }

    public void updatePortletPreferences(PortletPreferences portletPreferences, String portletId, String className, long classPK, ThemeDisplay themeDisplay) throws Exception {
        AssetEntry assetEntry = this._assetEntryLocalService.getEntry(className, classPK);
        AssetRendererFactory articleAssetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClass(JournalArticle.class);
        AssetRenderer articleAssetRenderer = articleAssetRendererFactory.getAssetRenderer(assetEntry.getClassPK());
        JournalArticle article = (JournalArticle)articleAssetRenderer.getAssetObject();
        portletPreferences.setValue("articleId", article.getArticleId());
        portletPreferences.setValue("groupId", String.valueOf(article.getGroupId()));
        portletPreferences.setValue("assetEntryId", String.valueOf(assetEntry.getEntryId()));
        Layout layout = themeDisplay.getLayout();
        this._addAssetEntryUsage(layout, portletId, article);
        this._journalContentSearchLocal.updateContentSearch(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), portletId, article.getArticleId(), true);
    }

    @Deprecated
    protected long getPlid(ThemeDisplay themeDisplay) {
        return themeDisplay.getPlid();
    }

    private void _addAssetEntryUsage(Layout layout, String portletId, JournalArticle article) throws PortalException {
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(this._portal.getClassNameId(JournalArticle.class), article.getResourcePrimKey());
        if (assetEntry == null) {
            return;
        }
        AssetEntryUsage assetEntryUsage = this._assetEntryUsageLocalService.fetchAssetEntryUsage(assetEntry.getEntryId(), this._portal.getClassNameId(Portlet.class), portletId, layout.getPlid());
        if (assetEntryUsage != null) {
            return;
        }
        this._assetEntryUsageLocalService.addAssetEntryUsage(layout.getGroupId(), assetEntry.getEntryId(), this._portal.getClassNameId(Portlet.class), portletId, layout.getPlid(), ServiceContextThreadLocal.getServiceContext());
    }
}

