/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.content.web.internal.display.context;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetEntryServiceUtil;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.journal.content.asset.addon.entry.ContentMetadataAssetAddonEntry;
import com.liferay.journal.content.asset.addon.entry.UserToolAssetAddonEntry;
import com.liferay.journal.content.web.configuration.JournalContentPortletInstanceConfiguration;
import com.liferay.journal.content.web.internal.security.permission.resource.JournalArticlePermission;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleDisplay;
import com.liferay.journal.model.JournalArticleResource;
import com.liferay.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.journal.service.JournalArticleResourceLocalServiceUtil;
import com.liferay.journal.util.JournalContent;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.servlet.taglib.ui.AssetAddonEntry;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.staging.StagingGroupHelper;
import com.liferay.staging.StagingGroupHelperUtil;
import com.liferay.trash.kernel.model.TrashEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class JournalContentDisplayContext {
    private static final boolean _STAGING_LIVE_GROUP_LOCKING_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get((String)"staging.live.group.locking.enabled"));
    private static final Log _log = LogFactoryUtil.getLog(JournalContentDisplayContext.class);
    private static final Comparator<AssetAddonEntry> _assetAddonEntryComparator = new Comparator<AssetAddonEntry>(){

        @Override
        public int compare(AssetAddonEntry assetAddonEntry1, AssetAddonEntry assetAddonEntry2) {
            return Double.compare(assetAddonEntry1.getWeight(), assetAddonEntry2.getWeight());
        }
    };
    private static final ServiceTrackerMap<String, ContentMetadataAssetAddonEntry> _contentMetadataAssetAddonEntryMap;
    private static final ServiceTrackerMap<String, UserToolAssetAddonEntry> _userToolAssetAddonEntryMap;
    private JournalArticle _article;
    private JournalArticleDisplay _articleDisplay;
    private Long _articleGroupId;
    private String _articleId;
    private List<ContentMetadataAssetAddonEntry> _contentMetadataAssetAddonEntries;
    private final long _ddmStructureClassNameId;
    private DDMTemplate _ddmTemplate;
    private String _ddmTemplateKey;
    private final ModelResourcePermission<DDMTemplate> _ddmTemplateModelResourcePermission;
    private List<DDMTemplate> _ddmTemplates;
    private DDMTemplate _defaultDDMTemplate;
    private Boolean _enableViewCountIncrement;
    private Boolean _expired;
    private Boolean _hasViewPermission;
    private final JournalContentPortletInstanceConfiguration _journalContentPortletInstanceConfiguration;
    private JournalArticle _latestArticle;
    private final PortletRequest _portletRequest;
    private String _portletResource;
    private final PortletResponse _portletResponse;
    private Boolean _preview;
    private Boolean _showArticle;
    private Boolean _showEditArticleIcon;
    private Boolean _showEditTemplateIcon;
    private Boolean _showSelectArticleLink;
    private List<UserToolAssetAddonEntry> _userToolAssetAddonEntries;

    public static JournalContentDisplayContext create(PortletRequest portletRequest, PortletResponse portletResponse, PortletDisplay portletDisplay, long ddmStructureClassNameId, ModelResourcePermission<DDMTemplate> ddmTemplateModelResourcePermission) throws PortalException {
        JournalContentDisplayContext journalContentDisplayContext = (JournalContentDisplayContext)portletRequest.getAttribute("JOURNAL_CONTENT_DISPLAY_CONTEXT");
        if (journalContentDisplayContext == null) {
            JournalContentPortletInstanceConfiguration journalContentPortletInstanceConfiguration = (JournalContentPortletInstanceConfiguration)portletDisplay.getPortletInstanceConfiguration(JournalContentPortletInstanceConfiguration.class);
            journalContentDisplayContext = new JournalContentDisplayContext(portletRequest, portletResponse, journalContentPortletInstanceConfiguration, ddmStructureClassNameId, ddmTemplateModelResourcePermission);
            portletRequest.setAttribute("JOURNAL_CONTENT_DISPLAY_CONTEXT", (Object)journalContentDisplayContext);
        }
        return journalContentDisplayContext;
    }

    public void clearCache() throws PortalException {
        String articleId = this.getArticleId();
        if (Validator.isNotNull((String)articleId)) {
            JournalContent journalContent = (JournalContent)this._portletRequest.getAttribute("JOURNAL_CONTENT");
            journalContent.clearCache(this.getArticleGroupId(), this.getArticleId(), this.getDDMTemplateKey());
        }
    }

    public JournalArticle getArticle() throws PortalException {
        JournalArticleResource articleResource;
        if (this._article != null) {
            return this._article;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._article = this._getArticleByPreviewAssetEntryId();
        if (this._article != null && JournalArticlePermission.contains(themeDisplay.getPermissionChecker(), this._article, "UPDATE")) {
            return this._article;
        }
        long articleResourcePrimKey = ParamUtil.getLong((PortletRequest)this._portletRequest, (String)"articleResourcePrimKey");
        if (articleResourcePrimKey == -1L) {
            return this._article;
        }
        if (articleResourcePrimKey == 0L && (articleResource = JournalArticleResourceLocalServiceUtil.fetchArticleResource((long)this.getArticleGroupId(), (String)this.getArticleId())) != null) {
            articleResourcePrimKey = articleResource.getResourcePrimKey();
        }
        this._article = JournalArticleLocalServiceUtil.fetchLatestArticle((long)articleResourcePrimKey, (int)-1, (boolean)true);
        return this._article;
    }

    public JournalArticleDisplay getArticleDisplay() throws PortalException {
        if (this._articleDisplay != null) {
            return this._articleDisplay;
        }
        JournalArticle article = this.getArticle();
        if (article == null) {
            return null;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String viewMode = ParamUtil.getString((PortletRequest)this._portletRequest, (String)"viewMode", null);
        String languageId = ParamUtil.getString((PortletRequest)this._portletRequest, (String)"languageId", (String)themeDisplay.getLanguageId());
        int page = ParamUtil.getInteger((PortletRequest)this._portletRequest, (String)"page", (int)1);
        if (article.isApproved()) {
            JournalContent journalContent = (JournalContent)this._portletRequest.getAttribute("JOURNAL_CONTENT");
            if (journalContent == null) {
                return null;
            }
            this._articleDisplay = journalContent.getDisplay(article.getGroupId(), article.getArticleId(), article.getVersion(), this.getDDMTemplateKey(), viewMode, languageId, page, new PortletRequestModel(this._portletRequest, this._portletResponse), themeDisplay);
        } else {
            try {
                this._articleDisplay = JournalArticleLocalServiceUtil.getArticleDisplay((JournalArticle)article, (String)this.getDDMTemplateKey(), (String)viewMode, (String)languageId, (int)page, (PortletRequestModel)new PortletRequestModel(this._portletRequest, this._portletResponse), (ThemeDisplay)themeDisplay);
            }
            catch (PortalException pe) {
                _log.error((Object)pe, (Throwable)pe);
            }
        }
        return this._articleDisplay;
    }

    public long getArticleGroupId() {
        if (this._articleGroupId != null) {
            return this._articleGroupId;
        }
        this._articleGroupId = ParamUtil.getLong((PortletRequest)this._portletRequest, (String)"groupId", (long)this._journalContentPortletInstanceConfiguration.groupId());
        if (this._articleGroupId <= 0L) {
            ThemeDisplay themeDisplay = (ThemeDisplay)this._portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this._articleGroupId = themeDisplay.getScopeGroupId();
        }
        return this._articleGroupId;
    }

    public String getArticleId() {
        if (this._articleId != null) {
            return this._articleId;
        }
        this._articleId = ParamUtil.getString((PortletRequest)this._portletRequest, (String)"articleId", (String)this._journalContentPortletInstanceConfiguration.articleId());
        return this._articleId;
    }

    public long getAssetEntryId() throws PortalException {
        JournalArticle article = this.getArticle();
        if (article == null) {
            return 0L;
        }
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClass(JournalArticle.class);
        AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer((Object)article, 0);
        long classPK = assetRenderer.getClassPK();
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.fetchEntry((String)JournalArticle.class.getName(), (long)classPK);
        return assetEntry.getEntryId();
    }

    public AssetRenderer<JournalArticle> getAssetRenderer() throws PortalException {
        JournalArticle article = this.getArticle();
        if (article == null) {
            return null;
        }
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClass(JournalArticle.class);
        if (assetRendererFactory == null) {
            return null;
        }
        return assetRendererFactory.getAssetRenderer((Object)article, 0);
    }

    public List<ContentMetadataAssetAddonEntry> getCommentsContentMetadataAssetAddonEntries() {
        ContentMetadataAssetAddonEntry enableCommentRatingsContentMetadataAssetAddonEntry;
        ArrayList<ContentMetadataAssetAddonEntry> commentsContentMetadataAssetAddonEntries = new ArrayList<ContentMetadataAssetAddonEntry>();
        ContentMetadataAssetAddonEntry enableCommentsContentMetadataAssetAddonEntry = this.getContentMetadataAssetAddonEntry("enableComments");
        if (enableCommentsContentMetadataAssetAddonEntry != null) {
            commentsContentMetadataAssetAddonEntries.add(enableCommentsContentMetadataAssetAddonEntry);
        }
        if ((enableCommentRatingsContentMetadataAssetAddonEntry = this.getContentMetadataAssetAddonEntry("enableCommentRatings")) != null) {
            commentsContentMetadataAssetAddonEntries.add(enableCommentRatingsContentMetadataAssetAddonEntry);
        }
        return commentsContentMetadataAssetAddonEntries;
    }

    public ContentMetadataAssetAddonEntry getContentMetadataAssetAddonEntry(String key) {
        ContentMetadataAssetAddonEntry contentMetadataAssetAddonEntry;
        String contentMetadataAssetAddonEntryKeysString = this._journalContentPortletInstanceConfiguration.contentMetadataAssetAddonEntryKeys();
        if (Validator.isNull((String)contentMetadataAssetAddonEntryKeysString)) {
            return null;
        }
        Object[] contentMetadataAssetAddonEntryKeys = StringUtil.split((String)contentMetadataAssetAddonEntryKeysString);
        if (ArrayUtil.contains((Object[])contentMetadataAssetAddonEntryKeys, (Object)key) && (contentMetadataAssetAddonEntry = (ContentMetadataAssetAddonEntry)_contentMetadataAssetAddonEntryMap.getService((Object)key)) != null && contentMetadataAssetAddonEntry.isEnabled()) {
            return contentMetadataAssetAddonEntry;
        }
        return null;
    }

    public DDMStructure getDDMStructure() throws PortalException {
        JournalArticle article = this.getArticle();
        if (article == null) {
            return null;
        }
        return article.getDDMStructure();
    }

    public DDMTemplate getDDMTemplate() throws PortalException {
        if (this._ddmTemplate != null) {
            return this._ddmTemplate;
        }
        this._ddmTemplate = this._getDDMTemplate(this.getDDMTemplateKey());
        return this._ddmTemplate;
    }

    public String getDDMTemplateKey() throws PortalException {
        JournalArticle article;
        if (this._ddmTemplateKey != null) {
            return this._ddmTemplateKey;
        }
        this._ddmTemplateKey = this._journalContentPortletInstanceConfiguration.ddmTemplateKey();
        String ddmTemplateKey = ParamUtil.getString((PortletRequest)this._portletRequest, (String)"ddmTemplateKey");
        if (Validator.isNotNull((String)ddmTemplateKey)) {
            this._ddmTemplateKey = ddmTemplateKey;
        }
        if ((article = this.getArticle()) == null) {
            return this._ddmTemplateKey;
        }
        List<DDMTemplate> ddmTemplates = this.getDDMTemplates();
        Stream stream = ddmTemplates.stream();
        boolean hasTemplate = stream.anyMatch(template -> this._ddmTemplateKey.equals(template.getTemplateKey()));
        if (!hasTemplate) {
            this._ddmTemplateKey = article.getDDMTemplateKey();
        }
        return this._ddmTemplateKey;
    }

    public List<DDMTemplate> getDDMTemplates() throws PortalException {
        if (this._ddmTemplates != null) {
            return this._ddmTemplates;
        }
        JournalArticle article = this.getArticle();
        if (article == null) {
            return Collections.emptyList();
        }
        try {
            DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)article.getGroupId(), (long)PortalUtil.getClassNameId(JournalArticle.class), (String)article.getDDMStructureKey(), (boolean)true);
            this._ddmTemplates = DDMTemplateLocalServiceUtil.getTemplates((long)article.getGroupId(), (long)PortalUtil.getClassNameId(DDMStructure.class), (long)ddmStructure.getStructureId(), (boolean)true);
        }
        catch (PortalException pe) {
            _log.error((Object)("Unable to get DDM temmplate for article " + article.getId()), (Throwable)pe);
        }
        return this._ddmTemplates;
    }

    public DDMTemplate getDefaultDDMTemplate() throws PortalException {
        if (this._defaultDDMTemplate != null) {
            return this._defaultDDMTemplate;
        }
        JournalArticle article = this.getArticle();
        this._defaultDDMTemplate = this._getDDMTemplate(article.getDDMTemplateKey());
        return this._defaultDDMTemplate;
    }

    public List<ContentMetadataAssetAddonEntry> getEnabledContentMetadataAssetAddonEntries() {
        List contentMetadataAssetAddonEntries = ListUtil.filter(new ArrayList(_contentMetadataAssetAddonEntryMap.values()), AssetAddonEntry::isEnabled);
        return ListUtil.sort((List)contentMetadataAssetAddonEntries, _assetAddonEntryComparator);
    }

    public List<UserToolAssetAddonEntry> getEnabledUserToolAssetAddonEntries() {
        List userToolAssetAddonEntries = ListUtil.filter(new ArrayList(_userToolAssetAddonEntryMap.values()), AssetAddonEntry::isEnabled);
        return ListUtil.sort((List)userToolAssetAddonEntries, _assetAddonEntryComparator);
    }

    public long getGroupId() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = themeDisplay.getScopeGroupId();
        Group scopeGroup = themeDisplay.getScopeGroup();
        if (scopeGroup.isStaged() && !scopeGroup.isInStagingPortlet("com_liferay_journal_web_portlet_JournalPortlet")) {
            groupId = scopeGroup.getLiveGroupId();
        }
        return groupId;
    }

    public JournalArticle getLatestArticle() throws PortalException {
        if (this._latestArticle != null) {
            return this._latestArticle;
        }
        JournalArticleDisplay articleDisplay = this.getArticleDisplay();
        if (articleDisplay == null) {
            return null;
        }
        this._latestArticle = JournalArticleLocalServiceUtil.fetchLatestArticle((long)articleDisplay.getGroupId(), (String)articleDisplay.getArticleId(), (int)-1);
        return this._latestArticle;
    }

    public String getPortletResource() {
        if (this._portletResource != null) {
            return this._portletResource;
        }
        this._portletResource = ParamUtil.getString((PortletRequest)this._portletRequest, (String)"portletResource");
        return this._portletResource;
    }

    public JournalArticle getSelectedArticle() {
        PortletPreferences portletPreferences = this._portletRequest.getPreferences();
        long assetEntryId = GetterUtil.getLong((String)portletPreferences.getValue("assetEntryId", ""));
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.fetchAssetEntry((long)assetEntryId);
        if (assetEntry == null) {
            return null;
        }
        return JournalArticleLocalServiceUtil.fetchLatestArticle((long)assetEntry.getClassPK());
    }

    public List<ContentMetadataAssetAddonEntry> getSelectedContentMetadataAssetAddonEntries() throws PortalException {
        String[] contentMetadataAssetAddonEntryKeys;
        if (this._contentMetadataAssetAddonEntries != null) {
            return this._contentMetadataAssetAddonEntries;
        }
        this._contentMetadataAssetAddonEntries = new ArrayList<ContentMetadataAssetAddonEntry>();
        String contentMetadataAssetAddonEntryKeysKeysString = this._journalContentPortletInstanceConfiguration.contentMetadataAssetAddonEntryKeys();
        if (Validator.isNull((String)contentMetadataAssetAddonEntryKeysKeysString)) {
            return this._contentMetadataAssetAddonEntries;
        }
        for (String contentMetadataAssetAddonEntryKey : contentMetadataAssetAddonEntryKeys = StringUtil.split((String)contentMetadataAssetAddonEntryKeysKeysString)) {
            ContentMetadataAssetAddonEntry contentMetadataAssetAddonEntry = (ContentMetadataAssetAddonEntry)_contentMetadataAssetAddonEntryMap.getService((Object)contentMetadataAssetAddonEntryKey);
            if (contentMetadataAssetAddonEntry == null) continue;
            this._contentMetadataAssetAddonEntries.add(contentMetadataAssetAddonEntry);
        }
        this._portletRequest.setAttribute("JOURNAL_ARTICLE", (Object)this.getArticle());
        this._portletRequest.setAttribute("JOURNAL_ARTICLE_DISPLAY", (Object)this.getArticleDisplay());
        return this._contentMetadataAssetAddonEntries;
    }

    public long[] getSelectedGroupIds() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Group scopeGroup = themeDisplay.getScopeGroup();
        if (scopeGroup.isStagingGroup() && !scopeGroup.isInStagingPortlet("com_liferay_journal_web_portlet_JournalPortlet")) {
            return new long[]{scopeGroup.getLiveGroupId()};
        }
        if (themeDisplay.getScopeGroupId() != themeDisplay.getSiteGroupId()) {
            return new long[]{themeDisplay.getScopeGroupId()};
        }
        return null;
    }

    public List<UserToolAssetAddonEntry> getSelectedUserToolAssetAddonEntries() throws PortalException {
        String[] userToolAssetAddonEntryKeys;
        if (this._userToolAssetAddonEntries != null) {
            return this._userToolAssetAddonEntries;
        }
        this._userToolAssetAddonEntries = new ArrayList<UserToolAssetAddonEntry>();
        String userToolAssetAddonEntryKeysString = this._journalContentPortletInstanceConfiguration.userToolAssetAddonEntryKeys();
        if (Validator.isNull((String)userToolAssetAddonEntryKeysString)) {
            return this._userToolAssetAddonEntries;
        }
        for (String userToolAssetAddonEntryKey : userToolAssetAddonEntryKeys = StringUtil.split((String)userToolAssetAddonEntryKeysString)) {
            UserToolAssetAddonEntry userToolAssetAddonEntry = (UserToolAssetAddonEntry)_userToolAssetAddonEntryMap.getService((Object)userToolAssetAddonEntryKey);
            if (userToolAssetAddonEntry == null) continue;
            this._userToolAssetAddonEntries.add(userToolAssetAddonEntry);
        }
        this._portletRequest.setAttribute("JOURNAL_ARTICLE", (Object)this.getArticle());
        this._portletRequest.setAttribute("JOURNAL_ARTICLE_DISPLAY", (Object)this.getArticleDisplay());
        return this._userToolAssetAddonEntries;
    }

    public String getURLEdit() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClass(JournalArticle.class);
            JournalArticle article = this.getArticle();
            AssetRenderer latestArticleAssetRenderer = assetRendererFactory.getAssetRenderer((Object)article, 1);
            PortletURL portletURL = latestArticleAssetRenderer.getURLEdit(PortalUtil.getLiferayPortletRequest((PortletRequest)this._portletRequest), null, LiferayWindowState.NORMAL, themeDisplay.getURLCurrent());
            return portletURL.toString();
        }
        catch (Exception e) {
            _log.error((Object)"Unable to get edit URL", (Throwable)e);
            return "";
        }
    }

    public String getURLEditTemplate() throws Exception {
        DDMTemplate ddmTemplate = this.getDDMTemplate();
        if (ddmTemplate == null) {
            return "";
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)this._portletRequest, (String)"com_liferay_journal_web_portlet_JournalPortlet", (String)"RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/edit_ddm_template.jsp");
        portletURL.setParameter("redirect", themeDisplay.getURLCurrent());
        portletURL.setParameter("ddmTemplateId", String.valueOf(ddmTemplate.getTemplateId()));
        portletURL.setPortletMode(PortletMode.VIEW);
        return portletURL.toString();
    }

    public String getURLViewHistory() {
        try {
            JournalArticle article = this.getArticle();
            ThemeDisplay themeDisplay = (ThemeDisplay)this._portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)this._portletRequest, (String)"com_liferay_journal_web_portlet_JournalPortlet", (String)"RENDER_PHASE");
            portletURL.setParameter("mvcPath", "/view_article_history.jsp");
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            portletURL.setParameter("referringPortletResource", portletDisplay.getId());
            portletURL.setParameter("groupId", String.valueOf(article.getGroupId()));
            portletURL.setParameter("articleId", article.getArticleId());
            portletURL.setParameter("showHeader", Boolean.TRUE.toString());
            portletURL.setWindowState(LiferayWindowState.POP_UP);
            return portletURL.toString();
        }
        catch (Exception e) {
            _log.error((Object)"Unable to get view history URL", (Throwable)e);
            return "";
        }
    }

    public boolean hasRestorePermission() throws PortalException {
        JournalArticle selectedArticle = this.getSelectedArticle();
        if (selectedArticle == null || !selectedArticle.isInTrash()) {
            return false;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)JournalArticle.class.getName());
        TrashEntry trashEntry = selectedArticle.getTrashEntry();
        return trashHandler.hasTrashPermission(themeDisplay.getPermissionChecker(), 0L, trashEntry.getClassPK(), "RESTORE");
    }

    public boolean hasViewPermission() throws PortalException {
        if (this._hasViewPermission != null) {
            return this._hasViewPermission;
        }
        this._hasViewPermission = true;
        JournalArticle article = this.getArticle();
        if (article != null) {
            ThemeDisplay themeDisplay = (ThemeDisplay)this._portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this._hasViewPermission = JournalArticlePermission.contains(themeDisplay.getPermissionChecker(), article, "VIEW");
        }
        return this._hasViewPermission;
    }

    public void incrementViewCounter() throws PortalException {
        JournalArticle article = this.getArticle();
        JournalArticleDisplay articleDisplay = this.getArticleDisplay();
        if (article == null || !this.hasViewPermission() || articleDisplay == null || this.isExpired() || !this.isEnableViewCountIncrement()) {
            return;
        }
        AssetEntryServiceUtil.incrementViewCounter((String)JournalArticle.class.getName(), (long)articleDisplay.getResourcePrimKey());
    }

    public boolean isDefaultTemplate() {
        String ddmTemplateKey = ParamUtil.getString((PortletRequest)this._portletRequest, (String)"ddmTemplateKey");
        if (Validator.isNotNull((String)ddmTemplateKey)) {
            return false;
        }
        ddmTemplateKey = this._journalContentPortletInstanceConfiguration.ddmTemplateKey();
        return !Validator.isNotNull((String)ddmTemplateKey);
    }

    public boolean isEnableViewCountIncrement() {
        if (this._enableViewCountIncrement != null) {
            return this._enableViewCountIncrement;
        }
        this._enableViewCountIncrement = Validator.isNotNull((Object)this._journalContentPortletInstanceConfiguration.enableViewCountIncrement()) ? Boolean.valueOf(GetterUtil.getBoolean((Object)this._journalContentPortletInstanceConfiguration.enableViewCountIncrement())) : Boolean.valueOf(PropsValues.ASSET_ENTRY_BUFFERED_INCREMENT_ENABLED);
        return this._enableViewCountIncrement;
    }

    public boolean isExpired() throws PortalException {
        Date expirationDate;
        if (this._expired != null) {
            return this._expired;
        }
        JournalArticle article = this.getArticle();
        this._expired = article.isExpired();
        if (!this._expired.booleanValue() && (expirationDate = article.getExpirationDate()) != null && expirationDate.before(new Date())) {
            this._expired = true;
        }
        return this._expired;
    }

    public boolean isPreview() {
        if (this._preview != null) {
            return this._preview;
        }
        JournalArticle article = this._getArticleByPreviewAssetEntryId();
        if (article == null) {
            this._preview = false;
            return this._preview;
        }
        this._preview = true;
        return this._preview;
    }

    public boolean isShowArticle() throws PortalException {
        if (this._showArticle != null) {
            return this._showArticle;
        }
        JournalArticle article = this.getArticle();
        if (article == null) {
            this._showArticle = false;
            return this._showArticle;
        }
        JournalArticleDisplay articleDisplay = this.getArticleDisplay();
        if (articleDisplay == null) {
            this._showArticle = false;
            return this._showArticle;
        }
        if (!this.hasViewPermission()) {
            this._showArticle = false;
            return this._showArticle;
        }
        if (this.isExpired()) {
            this._showArticle = false;
            return this._showArticle;
        }
        if (article.isScheduled() && !this.isPreview()) {
            this._showArticle = false;
            return this._showArticle;
        }
        if (article.isPending() && !this.isPreview()) {
            this._showArticle = false;
            return this._showArticle;
        }
        this._showArticle = true;
        return this._showArticle;
    }

    public boolean isShowEditArticleIcon() throws PortalException {
        if (this._showEditArticleIcon != null) {
            return this._showEditArticleIcon;
        }
        this._showEditArticleIcon = false;
        ThemeDisplay themeDisplay = (ThemeDisplay)this._portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Group group = themeDisplay.getScopeGroup();
        if (group.hasStagingGroup() && _STAGING_LIVE_GROUP_LOCKING_ENABLED) {
            return this._showEditArticleIcon;
        }
        JournalArticle latestArticle = this.getLatestArticle();
        if (latestArticle == null) {
            return this._showEditArticleIcon;
        }
        this._showEditArticleIcon = JournalArticlePermission.contains(themeDisplay.getPermissionChecker(), latestArticle, "UPDATE");
        return this._showEditArticleIcon;
    }

    public boolean isShowEditTemplateIcon() throws PortalException {
        if (this._showEditTemplateIcon != null) {
            return this._showEditTemplateIcon;
        }
        this._showEditTemplateIcon = false;
        DDMTemplate ddmTemplate = this.getDDMTemplate();
        if (ddmTemplate == null) {
            return this._showEditTemplateIcon;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            this._showEditTemplateIcon = this._ddmTemplateModelResourcePermission.contains(themeDisplay.getPermissionChecker(), (ClassedModel)ddmTemplate, "UPDATE");
        }
        catch (PortalException pe) {
            _log.error((Object)("Unable to check permission on DDM template " + ddmTemplate.getTemplateId()), (Throwable)pe);
        }
        return this._showEditTemplateIcon;
    }

    public boolean isShowSelectArticleLink() {
        if (this._showSelectArticleLink != null) {
            return this._showSelectArticleLink;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        if (layout.isLayoutPrototypeLinkActive()) {
            this._showSelectArticleLink = false;
            return this._showSelectArticleLink;
        }
        Group scopeGroup = themeDisplay.getScopeGroup();
        StagingGroupHelper stagingGroupHelper = StagingGroupHelperUtil.getStagingGroupHelper();
        if (stagingGroupHelper.isLocalLiveGroup(scopeGroup) || stagingGroupHelper.isRemoteLiveGroup(scopeGroup)) {
            this._showSelectArticleLink = false;
            return this._showSelectArticleLink;
        }
        this._showSelectArticleLink = true;
        return this._showSelectArticleLink;
    }

    private JournalContentDisplayContext(PortletRequest portletRequest, PortletResponse portletResponse, JournalContentPortletInstanceConfiguration journalContentPortletInstanceConfiguration, long ddmStructureClassNameId, ModelResourcePermission<DDMTemplate> ddmTemplateModelResourcePermission) throws PortalException {
        this._portletRequest = portletRequest;
        this._portletResponse = portletResponse;
        this._journalContentPortletInstanceConfiguration = journalContentPortletInstanceConfiguration;
        this._ddmStructureClassNameId = ddmStructureClassNameId;
        this._ddmTemplateModelResourcePermission = ddmTemplateModelResourcePermission;
        if (Validator.isNull((String)this.getPortletResource()) && !this.isShowArticle()) {
            portletRequest.setAttribute("PORTLET_CONFIGURATOR_VISIBILITY", (Object)Boolean.TRUE);
        }
    }

    private JournalArticle _getArticleByPreviewAssetEntryId() {
        long previewAssetEntryId = ParamUtil.getLong((PortletRequest)this._portletRequest, (String)"previewAssetEntryId");
        if (previewAssetEntryId <= 0L) {
            return null;
        }
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.fetchEntry((long)previewAssetEntryId);
        if (assetEntry == null) {
            return null;
        }
        AssetRendererFactory assetRendererFactory = assetEntry.getAssetRendererFactory();
        if (assetRendererFactory == null) {
            return null;
        }
        int previewAssetEntryType = ParamUtil.getInteger((PortletRequest)this._portletRequest, (String)"previewAssetEntryType", (int)1);
        try {
            AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(assetEntry.getClassPK(), previewAssetEntryType);
            return (JournalArticle)assetRenderer.getAssetObject();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private DDMTemplate _getDDMTemplate(String ddmTemplateKey) throws PortalException {
        JournalArticleDisplay articleDisplay = this.getArticleDisplay();
        if (articleDisplay == null) {
            return null;
        }
        return DDMTemplateLocalServiceUtil.fetchTemplate((long)articleDisplay.getGroupId(), (long)this._ddmStructureClassNameId, (String)ddmTemplateKey, (boolean)true);
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(JournalContentDisplayContext.class);
        BundleContext bundleContext = bundle.getBundleContext();
        _contentMetadataAssetAddonEntryMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ContentMetadataAssetAddonEntry.class, null, (serviceReference, emitter) -> {
            ContentMetadataAssetAddonEntry contentMetadataAssetAddonEntry = (ContentMetadataAssetAddonEntry)bundleContext.getService(serviceReference);
            emitter.emit((Object)contentMetadataAssetAddonEntry.getKey());
        });
        _userToolAssetAddonEntryMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, UserToolAssetAddonEntry.class, null, (serviceReference, emitter) -> {
            UserToolAssetAddonEntry userToolAssetAddonEntry = (UserToolAssetAddonEntry)bundleContext.getService(serviceReference);
            emitter.emit((Object)userToolAssetAddonEntry.getKey());
        });
    }
}

