/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.content.web.internal;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.model.AssetEntryUsage;
import com.liferay.asset.service.AssetEntryUsageLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalContentSearchLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletLayoutListener;
import com.liferay.portal.kernel.portlet.PortletLayoutListenerException;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_journal_content_web_portlet_JournalContentPortlet"}, service={PortletLayoutListener.class})
public class JournalContentPortletLayoutListener
implements PortletLayoutListener {
    private static final Log _log = LogFactoryUtil.getLog(JournalContentPortletLayoutListener.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetEntryUsageLocalService _assetEntryUsageLocalService;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalContentSearchLocalService _journalContentSearchLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;

    public void onAddToLayout(String portletId, long plid) throws PortletLayoutListenerException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Add ", portletId, " to layout ", plid}));
        }
        try {
            Layout layout = this._layoutLocalService.getLayout(plid);
            JournalArticle article = this._getArticle(layout, portletId);
            if (article == null) {
                return;
            }
            this._addAssetEntryUsage(layout, portletId, article);
            this._journalContentSearchLocalService.updateContentSearch(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), portletId, article.getArticleId(), true);
        }
        catch (Exception e) {
            throw new PortletLayoutListenerException((Throwable)e);
        }
    }

    public void onMoveInLayout(String portletId, long plid) throws PortletLayoutListenerException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Move ", portletId, " from in ", plid}));
        }
    }

    public void onRemoveFromLayout(String portletId, long plid) throws PortletLayoutListenerException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Remove ", portletId, " from layout ", plid}));
        }
        try {
            Layout layout = this._layoutLocalService.getLayout(plid);
            JournalArticle article = this._getArticle(layout, portletId);
            if (article == null) {
                return;
            }
            this._assetEntryUsageLocalService.deleteAssetEntryUsages(this._portal.getClassNameId(Portlet.class), portletId, plid);
            this._journalContentSearchLocalService.deleteArticleContentSearch(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), portletId, article.getArticleId());
            String[] runtimePortletIds = this.getRuntimePortletIds(layout.getCompanyId(), layout.getGroupId(), article.getArticleId());
            if (runtimePortletIds.length > 0) {
                this._portletLocalService.deletePortlets(layout.getCompanyId(), runtimePortletIds, layout.getPlid());
            }
        }
        catch (Exception e) {
            throw new PortletLayoutListenerException((Throwable)e);
        }
    }

    public void onSetup(String portletId, long plid) throws PortletLayoutListenerException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Setup ", portletId, " from layout ", plid}));
        }
        try {
            Layout layout = this._layoutLocalService.getLayout(plid);
            this._assetEntryUsageLocalService.deleteAssetEntryUsages(this._portal.getClassNameId(Portlet.class), portletId, plid);
            this._journalContentSearchLocalService.deleteArticleContentSearch(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), portletId);
            JournalArticle article = this._getArticle(layout, portletId);
            if (article != null) {
                this._addAssetEntryUsage(layout, portletId, article);
                this._journalContentSearchLocalService.updateContentSearch(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), portletId, article.getArticleId(), true);
            }
        }
        catch (Exception e) {
            throw new PortletLayoutListenerException((Throwable)e);
        }
    }

    public void updatePropertiesOnRemoveFromLayout(String portletId, UnicodeProperties typeSettingsProperties) throws PortletLayoutListenerException {
    }

    protected String getRuntimePortletId(String xml) throws Exception {
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        String portletName = rootElement.attributeValue("name");
        String instanceId = rootElement.attributeValue("instance");
        return PortletIdCodec.encode((String)portletName, (long)0L, (String)instanceId);
    }

    protected String[] getRuntimePortletIds(long companyId, long scopeGroupId, String articleId) throws Exception {
        DDMTemplate ddmTemplate;
        JournalArticle article = this._journalArticleLocalService.fetchDisplayArticle(scopeGroupId, articleId);
        if (article == null) {
            Group group = this._groupLocalService.fetchGroup(companyId);
            if (group == null) {
                return new String[0];
            }
            article = this._journalArticleLocalService.fetchDisplayArticle(group.getGroupId(), articleId);
            if (article == null) {
                return new String[0];
            }
        }
        Set<String> portletIds = this.getRuntimePortletIds(article.getContent());
        if (Validator.isNotNull((String)article.getDDMTemplateKey()) && (ddmTemplate = this._ddmTemplateLocalService.fetchTemplate(scopeGroupId, this._portal.getClassNameId(DDMStructure.class), article.getDDMTemplateKey(), true)) != null) {
            portletIds.addAll(this.getRuntimePortletIds(ddmTemplate.getScript()));
        }
        return portletIds.toArray(new String[0]);
    }

    protected Set<String> getRuntimePortletIds(String content) throws Exception {
        LinkedHashSet<String> portletIds = new LinkedHashSet<String>();
        int index = 0;
        while ((index = content.indexOf("<runtime-portlet", index)) != -1) {
            int close1 = content.indexOf("</runtime-portlet>", index);
            int close2 = content.indexOf("/>", index);
            int closeIndex = -1;
            closeIndex = close2 == -1 || close1 != -1 && close1 < close2 ? close1 + "</runtime-portlet>".length() : close2 + "/>".length();
            if (closeIndex == -1) break;
            portletIds.add(this.getRuntimePortletId(content.substring(index, closeIndex)));
            index = closeIndex;
        }
        return portletIds;
    }

    private void _addAssetEntryUsage(Layout layout, String portletId, JournalArticle article) {
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(this._portal.getClassNameId(JournalArticle.class), article.getResourcePrimKey());
        if (assetEntry == null) {
            return;
        }
        AssetEntryUsage assetEntryUsage = this._assetEntryUsageLocalService.fetchAssetEntryUsage(assetEntry.getEntryId(), this._portal.getClassNameId(Portlet.class), portletId, layout.getPlid());
        if (assetEntryUsage != null) {
            return;
        }
        this._assetEntryUsageLocalService.addAssetEntryUsage(layout.getGroupId(), assetEntry.getEntryId(), this._portal.getClassNameId(Portlet.class), portletId, layout.getPlid(), ServiceContextThreadLocal.getServiceContext());
    }

    private JournalArticle _getArticle(Layout layout, String portletId) {
        PortletPreferences portletPreferences = null;
        portletPreferences = layout.isPortletEmbedded(portletId, layout.getGroupId()) ? PortletPreferencesFactoryUtil.getLayoutPortletSetup((long)layout.getCompanyId(), (long)layout.getGroupId(), (int)3, (long)0L, (String)portletId, null) : PortletPreferencesFactoryUtil.getPortletSetup((Layout)layout, (String)portletId, (String)"");
        if (portletPreferences == null) {
            return null;
        }
        long groupId = GetterUtil.getLong((String)portletPreferences.getValue("groupId", null));
        String articleId = portletPreferences.getValue("articleId", null);
        return this._journalArticleLocalService.fetchArticle(groupId, articleId);
    }
}

