/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.content.web.internal.exportimport.portlet.preferences.processor;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.journal.content.web.internal.exportimport.portlet.preferences.processor.JournalContentMetadataExporterImporterCapability;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleResource;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalArticleResourceLocalService;
import com.liferay.journal.service.JournalContentSearchLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_journal_content_web_portlet_JournalContentPortlet"}, service={ExportImportPortletPreferencesProcessor.class})
public class JournalContentExportImportPortletPreferencesProcessor
implements ExportImportPortletPreferencesProcessor {
    private static final Log _log = LogFactoryUtil.getLog(JournalContentExportImportPortletPreferencesProcessor.class);
    @Reference(unbind="-")
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference(target="(name=ReferencedStagedModelImporter)")
    private Capability _capability;
    @Reference(unbind="-")
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference(unbind="-")
    private GroupLocalService _groupLocalService;
    @Reference(unbind="-")
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalArticleResourceLocalService _journalArticleResourceLocalService;
    @Reference
    private JournalContentMetadataExporterImporterCapability _journalContentMetadataExporterImporterCapability;
    @Reference(unbind="-")
    private JournalContentSearchLocalService _journalContentSearchLocalService;
    @Reference(unbind="-")
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    public List<Capability> getExportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this._journalContentMetadataExporterImporterCapability});
    }

    public List<Capability> getImportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this._journalContentMetadataExporterImporterCapability, this._capability});
    }

    public PortletPreferences processExportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        String portletId = portletDataContext.getPortletId();
        try {
            portletDataContext.addPortletPermissions("com.liferay.journal");
        }
        catch (PortalException pe) {
            PortletDataException pde = new PortletDataException((Throwable)pe);
            pde.setPortletId("com_liferay_journal_content_web_portlet_JournalContentPortlet");
            pde.setType(18);
            throw pde;
        }
        String articleId = portletPreferences.getValue("articleId", null);
        if (articleId == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No article ID found in preferences of portlet " + portletId));
            }
            return portletPreferences;
        }
        long articleGroupId = GetterUtil.getLong((String)portletPreferences.getValue("groupId", ""));
        if (articleGroupId <= 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No group ID found in preferences of portlet " + portletId));
            }
            return portletPreferences;
        }
        Group group = this._groupLocalService.fetchGroup(articleGroupId);
        if (ExportImportThreadLocal.isStagingInProcess() && !group.isStagedPortlet("com_liferay_journal_web_portlet_JournalPortlet")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Web content is not staged in the site " + group.getName()));
            }
            return portletPreferences;
        }
        long previousScopeGroupId = portletDataContext.getScopeGroupId();
        if (articleGroupId != previousScopeGroupId) {
            portletDataContext.setScopeGroupId(articleGroupId);
        }
        JournalArticle article = null;
        JournalArticleResource journalArticleResource = this._journalArticleResourceLocalService.fetchArticleResource(articleGroupId, articleId);
        if (journalArticleResource != null) {
            int[] statuses = new int[]{0, 3, 7};
            article = this._journalArticleLocalService.fetchLatestArticle(journalArticleResource.getResourcePrimKey(), statuses);
        }
        if (article == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Portlet ", portletId, " refers to an invalid article ID ", articleId}));
            }
            portletDataContext.setScopeGroupId(previousScopeGroupId);
            return portletPreferences;
        }
        if (!MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"PORTLET_DATA") && MergeLayoutPrototypesThreadLocal.isInProgress()) {
            portletDataContext.setScopeGroupId(previousScopeGroupId);
            return portletPreferences;
        }
        Map parameterMap = portletDataContext.getParameterMap();
        parameterMap.put("PORTLET_DATA_ALL", new String[]{Boolean.TRUE.toString()});
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)article);
        String defaultDDMTemplateKey = article.getDDMTemplateKey();
        String preferenceDDMTemplateKey = portletPreferences.getValue("ddmTemplateKey", null);
        if (Validator.isNotNull((String)defaultDDMTemplateKey) && Validator.isNotNull((String)preferenceDDMTemplateKey) && !defaultDDMTemplateKey.equals(preferenceDDMTemplateKey)) {
            try {
                DDMTemplate ddmTemplate = this._ddmTemplateLocalService.fetchTemplate(article.getGroupId(), this._portal.getClassNameId(DDMStructure.class), preferenceDDMTemplateKey, true);
                if (ddmTemplate == null) {
                    ddmTemplate = this._ddmTemplateLocalService.getTemplate(article.getGroupId(), this._portal.getClassNameId(DDMStructure.class), defaultDDMTemplateKey, true);
                    portletPreferences.setValue("ddmTemplateKey", defaultDDMTemplateKey);
                }
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)article, (StagedModel)ddmTemplate, (String)"strong");
            }
            catch (PortalException | ReadOnlyException e) {
                PortletDataException pde = new PortletDataException(e);
                pde.setPortletId("com_liferay_journal_content_web_portlet_JournalContentPortlet");
                pde.setType(19);
                throw pde;
            }
        }
        portletDataContext.setScopeGroupId(previousScopeGroupId);
        return portletPreferences;
    }

    public PortletPreferences processImportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            portletDataContext.importPortletPermissions("com.liferay.journal");
        }
        catch (PortalException pe) {
            PortletDataException pde = new PortletDataException((Throwable)pe);
            pde.setPortletId("com_liferay_journal_content_web_portlet_JournalContentPortlet");
            pde.setType(20);
            throw pde;
        }
        long previousScopeGroupId = portletDataContext.getScopeGroupId();
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long importGroupId = GetterUtil.getLong((String)portletPreferences.getValue("groupId", null));
        if (importGroupId == portletDataContext.getCompanyGroupId() && MergeLayoutPrototypesThreadLocal.isInProgress()) {
            portletDataContext.setScopeType("company");
        }
        long groupId = MapUtil.getLong((Map)groupIds, (long)importGroupId, (long)importGroupId);
        portletDataContext.setScopeGroupId(groupId);
        String articleId = portletPreferences.getValue("articleId", null);
        try {
            String ddmTemplateKey;
            Group importedArticleGroup;
            if (Validator.isNotNull((String)articleId) && (importedArticleGroup = this._groupLocalService.getGroup(groupId)).isStagedPortlet("com_liferay_journal_web_portlet_JournalPortlet")) {
                AssetEntry assetEntry;
                Map articleIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".articleId");
                articleId = MapUtil.getString((Map)articleIds, (String)articleId, (String)articleId);
                portletPreferences.setValue("articleId", articleId);
                portletPreferences.setValue("groupId", String.valueOf(groupId));
                JournalArticle article = this._journalArticleLocalService.fetchLatestArticle(groupId, articleId, -1);
                if (article != null && (assetEntry = this._assetEntryLocalService.fetchEntry(JournalArticle.class.getName(), article.getResourcePrimKey())) != null) {
                    portletPreferences.setValue("assetEntryId", String.valueOf(assetEntry.getEntryId()));
                }
                if (portletDataContext.getPlid() > 0L) {
                    Layout layout = this._layoutLocalService.fetchLayout(portletDataContext.getPlid());
                    this._journalContentSearchLocalService.updateContentSearch(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), portletDataContext.getPortletId(), articleId, true);
                }
            }
            if (Validator.isNotNull((String)(ddmTemplateKey = portletPreferences.getValue("ddmTemplateKey", null)))) {
                Map ddmTemplateKeys = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class + ".ddmTemplateKey");
                ddmTemplateKey = MapUtil.getString((Map)ddmTemplateKeys, (String)ddmTemplateKey, (String)ddmTemplateKey);
                portletPreferences.setValue("ddmTemplateKey", ddmTemplateKey);
            }
        }
        catch (PortalException pe) {
            PortletDataException pde = new PortletDataException((Throwable)pe);
            pde.setPortletId("com_liferay_journal_content_web_portlet_JournalContentPortlet");
            pde.setType(21);
            throw pde;
        }
        catch (ReadOnlyException roe) {
            PortletDataException pde = new PortletDataException((Throwable)roe);
            pde.setPortletId("com_liferay_journal_content_web_portlet_JournalContentPortlet");
            pde.setType(22);
            throw pde;
        }
        portletDataContext.setScopeGroupId(previousScopeGroupId);
        return portletPreferences;
    }
}

