/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.content.web.internal;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.journal.exception.NoSuchArticleException;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalContentSearchLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PortletInstance;
import com.liferay.portal.kernel.portlet.PortletLayoutListener;
import com.liferay.portal.kernel.portlet.PortletLayoutListenerException;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_journal_content_web_portlet_JournalContentPortlet"}, service={PortletLayoutListener.class})
public class JournalContentPortletLayoutListener
implements PortletLayoutListener {
    private static final Log _log = LogFactoryUtil.getLog(JournalContentPortletLayoutListener.class);
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalContentSearchLocalService _journalContentSearchLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;

    public void onAddToLayout(String portletId, long plid) throws PortletLayoutListenerException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Add ", portletId, " to layout ", String.valueOf(plid)}));
        }
        try {
            Layout layout = this._layoutLocalService.getLayout(plid);
            PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getPortletSetup((Layout)layout, (String)portletId, (String)"");
            String articleId = portletPreferences.getValue("articleId", null);
            if (Validator.isNull((String)articleId)) {
                return;
            }
            this._journalContentSearchLocalService.updateContentSearch(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), portletId, articleId, true);
        }
        catch (Exception e) {
            throw new PortletLayoutListenerException((Throwable)e);
        }
    }

    public void onMoveInLayout(String portletId, long plid) throws PortletLayoutListenerException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Move ", portletId, " from in ", String.valueOf(plid)}));
        }
    }

    public void onRemoveFromLayout(String portletId, long plid) throws PortletLayoutListenerException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Remove ", portletId, " from layout ", String.valueOf(plid)}));
        }
        try {
            Layout layout = this._layoutLocalService.getLayout(plid);
            PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getPortletSetup((Layout)layout, (String)portletId, (String)"");
            String articleId = portletPreferences.getValue("articleId", null);
            if (Validator.isNull((String)articleId)) {
                return;
            }
            this._journalContentSearchLocalService.deleteArticleContentSearch(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), portletId, articleId);
            String[] runtimePortletIds = this.getRuntimePortletIds(layout.getCompanyId(), layout.getGroupId(), articleId);
            if (runtimePortletIds.length > 0) {
                this._portletLocalService.deletePortlets(layout.getCompanyId(), runtimePortletIds, layout.getPlid());
            }
        }
        catch (Exception e) {
            throw new PortletLayoutListenerException((Throwable)e);
        }
    }

    public void onSetup(String portletId, long plid) throws PortletLayoutListenerException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Setup ", portletId, " from layout ", String.valueOf(plid)}));
        }
        try {
            Layout layout = this._layoutLocalService.getLayout(plid);
            PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getPortletSetup((Layout)layout, (String)portletId, (String)"");
            String articleId = portletPreferences.getValue("articleId", null);
            if (Validator.isNull((String)articleId)) {
                this._journalContentSearchLocalService.deleteArticleContentSearch(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), portletId);
                return;
            }
            this._journalContentSearchLocalService.updateContentSearch(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), portletId, articleId, true);
        }
        catch (Exception e) {
            throw new PortletLayoutListenerException((Throwable)e);
        }
    }

    public void updatePropertiesOnRemoveFromLayout(String portletId, UnicodeProperties typeSettingsProperties) throws PortletLayoutListenerException {
    }

    protected String getRuntimePortletId(String xml) throws Exception {
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        String portletName = rootElement.attributeValue("name");
        String instanceId = rootElement.attributeValue("instance");
        PortletInstance portletInstance = new PortletInstance(portletName, instanceId);
        return portletInstance.getPortletInstanceKey();
    }

    protected String[] getRuntimePortletIds(long companyId, long scopeGroupId, String articleId) throws Exception {
        Group group = this._groupLocalService.getCompanyGroup(companyId);
        JournalArticle article = null;
        try {
            article = this._journalArticleLocalService.getDisplayArticle(scopeGroupId, articleId);
        }
        catch (NoSuchArticleException noSuchArticleException) {
            // empty catch block
        }
        if (article == null) {
            try {
                article = this._journalArticleLocalService.getDisplayArticle(group.getGroupId(), articleId);
            }
            catch (NoSuchArticleException nsae) {
                return new String[0];
            }
        }
        Set<String> portletIds = this.getRuntimePortletIds(article.getContent());
        if (Validator.isNotNull((String)article.getDDMTemplateKey())) {
            DDMTemplate ddmTemplate = this._ddmTemplateLocalService.getTemplate(scopeGroupId, this._portal.getClassNameId(DDMStructure.class), article.getDDMTemplateKey(), true);
            portletIds.addAll(this.getRuntimePortletIds(ddmTemplate.getScript()));
        }
        return portletIds.toArray(new String[portletIds.size()]);
    }

    protected Set<String> getRuntimePortletIds(String content) throws Exception {
        LinkedHashSet<String> portletIds = new LinkedHashSet<String>();
        int index = 0;
        while ((index = content.indexOf("<runtime-portlet", index)) != -1) {
            int close1 = content.indexOf("</runtime-portlet>", index);
            int close2 = content.indexOf("/>", index);
            int closeIndex = -1;
            closeIndex = close2 == -1 || close1 != -1 && close1 < close2 ? close1 + "</runtime-portlet>".length() : close2 + "/>".length();
            if (closeIndex == -1) break;
            portletIds.add(this.getRuntimePortletId(content.substring(index, closeIndex)));
            index = closeIndex;
        }
        return portletIds;
    }
}

