/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.util.comparator;

import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Date;

public class ArticleDisplayDateComparator
extends OrderByComparator<JournalArticle> {
    public static final String ORDER_BY_ASC = "JournalArticle.displayDate ASC, JournalArticle.version ASC";
    public static final String ORDER_BY_DESC = "JournalArticle.displayDate DESC, JournalArticle.version DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"displayDate", "version"};
    private final boolean _ascending;

    public ArticleDisplayDateComparator() {
        this(false);
    }

    public ArticleDisplayDateComparator(boolean ascending) {
        this._ascending = ascending;
    }

    public int compare(JournalArticle article1, JournalArticle article2) {
        int value = DateUtil.compareTo((Date)article1.getDisplayDate(), (Date)article2.getDisplayDate());
        if (value == 0) {
            if (article1.getVersion() < article2.getVersion()) {
                value = -1;
            } else if (article1.getVersion() > article2.getVersion()) {
                value = 1;
            }
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }
}

