/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.exception;

import com.liferay.journal.model.JournalFolder;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import java.util.Locale;

public class InvalidFolderException
extends PortalException {
    public static final int CANNOT_MOVE_INTO_CHILD_FOLDER = 1;
    public static final int CANNOT_MOVE_INTO_ITSELF = 2;
    public static final int INVALID_GROUP = 3;
    public static final int PARENT_FOLDER_DOES_NOT_EXIST = 4;
    private final JournalFolder _folder;
    private final int _type;

    public InvalidFolderException(int type) {
        this._type = type;
        this._folder = null;
    }

    public InvalidFolderException(JournalFolder folder, int type) {
        this._folder = folder;
        this._type = type;
    }

    public JournalFolder getFolder() {
        return this._folder;
    }

    public String getMessageArgument(Locale locale) {
        if (this._folder == null) {
            return LanguageUtil.get((Locale)locale, (String)"home");
        }
        return this._folder.getName();
    }

    public String getMessageKey() {
        if (this._type == 1) {
            return "unable-to-move-folder-x-into-one-of-its-children";
        }
        if (this._type == 2) {
            return "unable-to-move-folder-x-into-itself";
        }
        if (this._type == 3) {
            return "folder-cannot-be-moved-to-another-site";
        }
        if (this._type == 4) {
            return "parent-folder-does-not-exist";
        }
        return null;
    }
}

