/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.util.comparator;

import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Date;

public class ArticleReviewDateComparator
extends OrderByComparator<JournalArticle> {
    public static final String ORDER_BY_ASC = "JournalArticle.reviewDate ASC, JournalArticle.version ASC";
    public static final String ORDER_BY_DESC = "JournalArticle.reviewDate DESC, JournalArticle.version DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"reviewDate", "version"};
    private final boolean _ascending;

    public ArticleReviewDateComparator() {
        this(false);
    }

    public ArticleReviewDateComparator(boolean ascending) {
        this._ascending = ascending;
    }

    public int compare(JournalArticle article1, JournalArticle article2) {
        int value = DateUtil.compareTo((Date)article1.getReviewDate(), (Date)article2.getReviewDate());
        if (value == 0) {
            if (article1.getVersion() < article2.getVersion()) {
                value = -1;
            } else if (article1.getVersion() > article2.getVersion()) {
                value = 1;
            }
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }
}

