/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.util.comparator;

import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;

public class ArticleIDComparator
extends OrderByComparator<JournalArticle> {
    public static final String ORDER_BY_ASC = "JournalArticle.articleId ASC, JournalArticle.version ASC";
    public static final String ORDER_BY_DESC = "JournalArticle.articleId DESC, JournalArticle.version DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"articleId", "version"};
    private final boolean _ascending;

    public ArticleIDComparator() {
        this(false);
    }

    public ArticleIDComparator(boolean ascending) {
        this._ascending = ascending;
    }

    public int compare(JournalArticle article1, JournalArticle article2) {
        String articleId2;
        String articleId1 = StringUtil.toLowerCase((String)article1.getArticleId());
        int value = articleId1.compareTo(articleId2 = StringUtil.toLowerCase((String)article2.getArticleId()));
        if (value == 0) {
            if (article1.getVersion() < article2.getVersion()) {
                value = -1;
            } else if (article1.getVersion() > article2.getVersion()) {
                value = 1;
            }
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }
}

