/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.testray.TestrayAttachment;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayCase;
import com.liferay.jenkins.results.parser.testray.TestrayFactory;
import com.liferay.jenkins.results.parser.testray.TestrayProject;
import com.liferay.jenkins.results.parser.testray.TestrayServer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class TestrayCaseResult {
    protected final JSONObject jsonObject;
    private Map<String, TestrayAttachment> _testrayAttachments;
    private final TestrayBuild _testrayBuild;
    private TestrayCase _testrayCase;
    private TopLevelBuild _topLevelBuild;

    public TestrayCaseResult(TestrayBuild testrayBuild, JSONObject jsonObject) {
        this._testrayBuild = testrayBuild;
        this.jsonObject = jsonObject;
    }

    public TestrayCaseResult(TestrayBuild testrayBuild, TopLevelBuild topLevelBuild) {
        this._testrayBuild = testrayBuild;
        this._topLevelBuild = topLevelBuild;
        this.jsonObject = new JSONObject();
    }

    public TestrayAttachment getBuildResultTestrayAttachment() {
        this._initTestrayAttachments();
        return this._testrayAttachments.get("Build Result (Top Level)");
    }

    public String getCaseID() {
        return this.jsonObject.optString("testrayCaseId");
    }

    public String getComponentName() {
        return this.jsonObject.getString("testrayComponentName");
    }

    public String getErrors() {
        return this.jsonObject.optString("errors");
    }

    public String getID() {
        return this.jsonObject.optString("testrayCaseResultId");
    }

    public JSONObject getJSONObject() {
        return this.jsonObject;
    }

    public String getName() {
        return this.jsonObject.optString("testrayCaseName");
    }

    public int getPriority() {
        TestrayCase testrayCase = this.getTestrayCase();
        return testrayCase.getPriority();
    }

    public Status getStatus() {
        int statusID = this.jsonObject.optInt("status");
        return Status.get(statusID);
    }

    public String getSubcomponentNames() {
        return "";
    }

    public String getTeamName() {
        return this.jsonObject.getString("testrayTeamName");
    }

    public List<TestrayAttachment> getTestrayAttachments() {
        this._initTestrayAttachments();
        return new ArrayList<TestrayAttachment>(this._testrayAttachments.values());
    }

    public TestrayBuild getTestrayBuild() {
        return this._testrayBuild;
    }

    public TestrayCase getTestrayCase() {
        if (this._testrayCase != null) {
            return this._testrayCase;
        }
        TestrayServer testrayServer = this.getTestrayServer();
        String testrayCaseURL = JenkinsResultsParserUtil.combine(String.valueOf(testrayServer.getURL()), "/home/-/testray/cases/", this.getCaseID(), ".json");
        try {
            this._testrayCase = new TestrayCase(this.getTestrayProject(), JenkinsResultsParserUtil.toJSONObject(testrayCaseURL));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return this._testrayCase;
    }

    public TestrayProject getTestrayProject() {
        return this._testrayBuild.getTestrayProject();
    }

    public TestrayServer getTestrayServer() {
        return this._testrayBuild.getTestrayServer();
    }

    public TopLevelBuild getTopLevelBuild() {
        return this._topLevelBuild;
    }

    public String getType() {
        TestrayCase testrayCase = this.getTestrayCase();
        return testrayCase.getType();
    }

    public URL getURL() {
        TestrayServer testrayServer = this.getTestrayServer();
        try {
            return new URL(testrayServer.getURL(), JenkinsResultsParserUtil.combine("home/-/testray/case_results/", this.getID()));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public String[] getWarnings() {
        JSONArray jsonArray = this.jsonObject.optJSONArray("warnings");
        if (jsonArray == null) {
            return null;
        }
        String[] warnings = new String[jsonArray.length()];
        for (int i = 0; i < warnings.length; ++i) {
            warnings[i] = jsonArray.optString(i);
        }
        return warnings;
    }

    private void _initTestrayAttachments() {
        if (this._testrayAttachments != null) {
            return;
        }
        this._testrayAttachments = new TreeMap<String, TestrayAttachment>();
        JSONObject attachmentsJSONObject = this.jsonObject.optJSONObject("attachments");
        for (String name : attachmentsJSONObject.keySet()) {
            TestrayAttachment testrayAttachment = TestrayFactory.newTestrayAttachment(this, name, attachmentsJSONObject.getString(name));
            this._testrayAttachments.put(testrayAttachment.getName(), testrayAttachment);
        }
    }

    public static enum Status {
        BLOCKED(4, "blocked"),
        DID_NOT_RUN(6, "dnr"),
        FAILED(3, "failed"),
        IN_PROGRESS(1, "in-progress"),
        PASSED(2, "passed"),
        TEST_FIX(7, "test-fix"),
        UNTESTED(1, "untested");

        private static Map<Integer, Status> _statuses;
        private final Integer _id;
        private final String _name;

        public static Status get(Integer id) {
            return _statuses.get(id);
        }

        public static List<Status> getFailedStatuses() {
            return Arrays.asList(BLOCKED, DID_NOT_RUN, FAILED, IN_PROGRESS, TEST_FIX, UNTESTED);
        }

        public Integer getID() {
            return this._id;
        }

        public String getName() {
            return this._name;
        }

        private Status(Integer id, String name) {
            this._id = id;
            this._name = name;
        }

        static {
            _statuses = new HashMap<Integer, Status>();
            for (Status status : Status.values()) {
                _statuses.put(status.getID(), status);
            }
        }
    }
}

