/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TestrayResultsParserUtil;
import com.liferay.jenkins.results.parser.testray.BaseTestrayServer;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeoutException;

public class RsyncTestrayServer
extends BaseTestrayServer {
    public RsyncTestrayServer(String urlString) {
        super(urlString);
    }

    @Override
    public void importCaseResults(JenkinsMaster jenkinsMaster) {
        TestrayResultsParserUtil.processTestrayResultFiles(this.getResultsDir());
        String command = JenkinsResultsParserUtil.combine("rsync -aqz --chmod=go=rx \"", JenkinsResultsParserUtil.getCanonicalPath(this.getResultsDir()), "\"/* \"", jenkinsMaster.getName(), "::testray-results/production/\"");
        try {
            JenkinsResultsParserUtil.executeBashCommands(command);
        }
        catch (IOException | TimeoutException exception) {
            throw new RuntimeException(exception);
        }
        for (File resultFile : JenkinsResultsParserUtil.findFiles(this.getResultsDir(), ".*.xml")) {
            System.out.println(JenkinsResultsParserUtil.combine("Uploaded ", JenkinsResultsParserUtil.getCanonicalPath(resultFile), " by Rsync"));
            JenkinsResultsParserUtil.delete(resultFile);
        }
    }
}

