/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.RemoteExecutor;
import com.liferay.jenkins.results.parser.testray.BaseTestrayAttachmentUploader;
import com.liferay.jenkins.results.parser.testray.TestrayAttachmentRecorder;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class RsyncTestrayAttachmentUploader
extends BaseTestrayAttachmentUploader {
    private List<File> _sourceTestrayLogsFiles;
    private final URL _testrayServerURL;
    private boolean _uploaded;

    public RsyncTestrayAttachmentUploader(Build build, URL testrayServerURL) {
        super(build);
        this._testrayServerURL = testrayServerURL;
    }

    @Override
    public void upload() {
        if (this._uploaded) {
            return;
        }
        TestrayAttachmentRecorder testrayAttachmentRecorder = this.getTestrayAttachmentRecorder();
        testrayAttachmentRecorder.record();
        this.makeRemoteDestDirs();
        this.rsync();
        this._uploaded = true;
    }

    protected void makeRemoteDestDirs() {
        RemoteExecutor remoteExecutor = new RemoteExecutor();
        ArrayList<String> commands = new ArrayList<String>();
        ArrayList<File> sourceTestrayLogsParentDirs = new ArrayList<File>();
        for (File sourceTestrayLogsFile : this._getSourceTestrayLogsFiles()) {
            File sourceTestrayLogsParentDir = sourceTestrayLogsFile.getParentFile();
            if (sourceTestrayLogsParentDir == null || !sourceTestrayLogsParentDir.isDirectory() || sourceTestrayLogsParentDirs.contains(sourceTestrayLogsParentDir)) continue;
            sourceTestrayLogsParentDirs.add(sourceTestrayLogsParentDir);
            commands.add(JenkinsResultsParserUtil.combine("mkdir -p \"", this._getTestrayMountDirPath(), "/jenkins/testray-results/production/logs/", JenkinsResultsParserUtil.getPathRelativeTo(sourceTestrayLogsParentDir, this._getSourceTestrayLogsDir()), "\""));
        }
        if (JenkinsResultsParserUtil.isWindows()) {
            remoteExecutor.execute(1, new String[]{"root@" + this._getMasterHostname()}, commands.toArray(new String[0]));
        } else {
            remoteExecutor.execute(1, new String[]{this._getMasterHostname()}, commands.toArray(new String[0]));
        }
    }

    protected void rsync() {
        String[] commands = null;
        commands = JenkinsResultsParserUtil.isWindows() ? new String[]{JenkinsResultsParserUtil.combine("cd ", JenkinsResultsParserUtil.getCanonicalPath(this._getSourceTestrayLogsDir())), JenkinsResultsParserUtil.combine("rsync -aqz --chmod=go=rx ./* \"root@", this._getMasterHostname(), "::testray-results/production/logs/\"")} : new String[]{JenkinsResultsParserUtil.combine("rsync -aqz --chmod=go=rx \"", JenkinsResultsParserUtil.getCanonicalPath(this._getSourceTestrayLogsDir()), "\"/* \"", this._getMasterHostname(), "::testray-results/production/logs/\"")};
        try {
            JenkinsResultsParserUtil.executeBashCommands(commands);
        }
        catch (IOException | TimeoutException exception) {
            throw new RuntimeException(exception);
        }
        for (File sourceTestrayLogsFile : this._getSourceTestrayLogsFiles()) {
            System.out.println(JenkinsResultsParserUtil.combine("Uploaded ", String.valueOf(this._testrayServerURL), "/reports/production/logs/", JenkinsResultsParserUtil.fixURL(JenkinsResultsParserUtil.getPathRelativeTo(sourceTestrayLogsFile, this._getSourceTestrayLogsDir()))));
        }
    }

    private String _getMasterHostname() {
        Build build = this.getBuild();
        JenkinsMaster jenkinsMaster = build.getJenkinsMaster();
        return jenkinsMaster.getName();
    }

    private File _getSourceTestrayLogsDir() {
        TestrayAttachmentRecorder testrayAttachmentRecorder = this.getTestrayAttachmentRecorder();
        return testrayAttachmentRecorder.getTestrayLogsDir();
    }

    private List<File> _getSourceTestrayLogsFiles() {
        if (this._sourceTestrayLogsFiles != null) {
            return this._sourceTestrayLogsFiles;
        }
        this._sourceTestrayLogsFiles = JenkinsResultsParserUtil.findFiles(this._getSourceTestrayLogsDir(), ".*");
        return this._sourceTestrayLogsFiles;
    }

    private String _getTestrayMountDirPath() {
        try {
            return JenkinsResultsParserUtil.getBuildProperty("testray.server.mount.dir[testray-1]");
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

