/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.testray;

import com.liferay.jenkins.results.parser.AxisBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.testray.TestrayAttachment;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class BatchTestrayCaseResult
extends TestrayCaseResult {
    private final AxisTestClassGroup _axisTestClassGroup;

    public BatchTestrayCaseResult(TestrayBuild testrayBuild, TopLevelBuild topLevelBuild, AxisTestClassGroup axisTestClassGroup) {
        super(testrayBuild, topLevelBuild);
        this._axisTestClassGroup = axisTestClassGroup;
    }

    public AxisBuild getAxisBuild() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        return topLevelBuild.getDownstreamAxisBuild(this._axisTestClassGroup.getAxisName());
    }

    public String getAxisName() {
        return this._axisTestClassGroup.getAxisName();
    }

    public String getBatchName() {
        return this._axisTestClassGroup.getBatchName();
    }

    public Build getBuild() {
        return this.getAxisBuild();
    }

    @Override
    public String getComponentName() {
        try {
            return JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "testray.case.component", this.getBatchName());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public String getErrors() {
        Build build = this.getBuild();
        if (build == null) {
            return "Failed to run on CI";
        }
        if (!build.isFailing()) {
            return null;
        }
        String result = build.getResult();
        if (result == null) {
            return "Failed to finish build on CI";
        }
        if (result.equals("ABORTED")) {
            return "Aborted prior to running test";
        }
        String errorMessage = build.getFailureMessage();
        if (JenkinsResultsParserUtil.isNullOrEmpty(errorMessage)) {
            return "Failed for unknown reason";
        }
        if (errorMessage.contains("\n")) {
            errorMessage = errorMessage.substring(0, errorMessage.indexOf("\n"));
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(errorMessage = errorMessage.trim())) {
            return "Failed for unknown reason";
        }
        return errorMessage;
    }

    @Override
    public String getName() {
        return this.getAxisName();
    }

    @Override
    public int getPriority() {
        try {
            String testrayCasePriority = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "testray.case.priority", this.getBatchName());
            if (testrayCasePriority != null && testrayCasePriority.matches("\\d+")) {
                return Integer.parseInt(testrayCasePriority);
            }
            return 5;
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public TestrayCaseResult.Status getStatus() {
        Build build = this.getBuild();
        if (build == null) {
            return TestrayCaseResult.Status.UNTESTED;
        }
        if (build.isFailing()) {
            return TestrayCaseResult.Status.FAILED;
        }
        return TestrayCaseResult.Status.PASSED;
    }

    @Override
    public String getTeamName() {
        try {
            return JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "testray.case.team", this.getBatchName());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public List<TestrayAttachment> getTestrayAttachments() {
        ArrayList<TestrayAttachment> testrayAttachments = new ArrayList<TestrayAttachment>();
        testrayAttachments.add(this._getBuildResultTopLevelTestrayAttachment());
        testrayAttachments.add(this._getJenkinsConsoleTestrayAttachment());
        testrayAttachments.add(this._getJenkinsConsoleTopLevelTestrayAttachment());
        testrayAttachments.add(this._getJenkinsReportTestrayAttachment());
        testrayAttachments.removeAll(Collections.singleton(null));
        return testrayAttachments;
    }

    @Override
    public String getType() {
        try {
            return JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "testray.case.type", this.getBatchName());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    public String[] getWarnings() {
        return null;
    }

    protected String getAxisBuildURLPath() {
        AxisBuild axisBuild = this.getAxisBuild();
        if (axisBuild == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this._getTopLevelBuildURLPath());
        sb.append("/");
        sb.append(axisBuild.getAxisName());
        return sb.toString();
    }

    protected AxisTestClassGroup getAxisTestClassGroup() {
        return this._axisTestClassGroup;
    }

    private TestrayAttachment _getBuildResultTopLevelTestrayAttachment() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        if (topLevelBuild == null) {
            return null;
        }
        TestrayAttachment testrayAttachment = TestrayFactory.newTestrayAttachment(this, "Build Result (Top Level)", JenkinsResultsParserUtil.combine(this._getTopLevelBuildURLPath(), "/build-result.json.gz"));
        if (!testrayAttachment.exists()) {
            return null;
        }
        return testrayAttachment;
    }

    private TestrayAttachment _getJenkinsConsoleTestrayAttachment() {
        AxisBuild axisBuild = this.getAxisBuild();
        if (axisBuild == null) {
            return null;
        }
        TestrayAttachment testrayAttachment = TestrayFactory.newTestrayAttachment(this, "Jenkins Console", JenkinsResultsParserUtil.combine(this.getAxisBuildURLPath(), "/jenkins-console.txt.gz"));
        if (!testrayAttachment.exists()) {
            return null;
        }
        return testrayAttachment;
    }

    private TestrayAttachment _getJenkinsConsoleTopLevelTestrayAttachment() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        if (topLevelBuild == null) {
            return null;
        }
        TestrayAttachment testrayAttachment = TestrayFactory.newTestrayAttachment(this, "Jenkins Console (Top Level)", JenkinsResultsParserUtil.combine(this._getTopLevelBuildURLPath(), "/jenkins-console.txt.gz"));
        if (!testrayAttachment.exists()) {
            return null;
        }
        return testrayAttachment;
    }

    private TestrayAttachment _getJenkinsReportTestrayAttachment() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        if (topLevelBuild == null) {
            return null;
        }
        TestrayAttachment testrayAttachment = TestrayFactory.newTestrayAttachment(this, "Jenkins Report (Top Level)", JenkinsResultsParserUtil.combine(this._getTopLevelBuildURLPath(), "/jenkins-report.html.gz"));
        if (!testrayAttachment.exists()) {
            return null;
        }
        return testrayAttachment;
    }

    private String _getTopLevelBuildURLPath() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        if (topLevelBuild == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Date date = new Date(topLevelBuild.getStartTime());
        sb.append(JenkinsResultsParserUtil.toDateString(date, "yyyy-MM", "America/Los_Angeles"));
        sb.append("/");
        JenkinsMaster jenkinsMaster = topLevelBuild.getJenkinsMaster();
        sb.append(jenkinsMaster.getName());
        sb.append("/");
        sb.append(topLevelBuild.getJobName());
        sb.append("/");
        sb.append(topLevelBuild.getBuildNumber());
        return sb.toString();
    }
}

