/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalAWSJob;
import com.liferay.jenkins.results.parser.PortalEnvironmentJob;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.QAWebsitesGitRepositoryJob;
import com.liferay.jenkins.results.parser.RootCauseAnalysisToolJob;
import com.liferay.jenkins.results.parser.test.clazz.group.AWSFunctionalSegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.CompileModulesBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.CucumberAxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.CucumberBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.DefaultBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.EnvironmentFunctionalBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.EnvironmentFunctionalSegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalAxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalRCABatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalSegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.IntegrationJUnitBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.JSUnitModulesBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.JSUnitModulesSegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.JUnitAxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.JUnitBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.JUnitRCABatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.JUnitSegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.ModulesIntegrationJUnitBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.ModulesUnitJUnitBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.NPMTestBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.PluginsBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.PluginsFunctionalBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.PluginsGulpAxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.PluginsGulpBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.PluginsGulpSegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.PluginsSegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.QAWebsitesFunctionalBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.QAWebsitesFunctionalSegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.RCABatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.RESTBuilderModulesBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.SegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.SemVerModulesBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.ServiceBuilderModulesBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TCKJunitBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.UnitJUnitBatchTestClassGroup;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class TestClassGroupFactory {
    private static final Map<String, BatchTestClassGroup> _batchTestClassGroups = new HashMap<String, BatchTestClassGroup>();

    public static AxisTestClassGroup newAxisTestClassGroup(BatchTestClassGroup batchTestClassGroup) {
        return TestClassGroupFactory.newAxisTestClassGroup(batchTestClassGroup, null);
    }

    public static AxisTestClassGroup newAxisTestClassGroup(BatchTestClassGroup batchTestClassGroup, File testBaseDir) {
        if (batchTestClassGroup instanceof CucumberBatchTestClassGroup) {
            return new CucumberAxisTestClassGroup((CucumberBatchTestClassGroup)batchTestClassGroup);
        }
        if (batchTestClassGroup instanceof FunctionalBatchTestClassGroup) {
            return new FunctionalAxisTestClassGroup((FunctionalBatchTestClassGroup)batchTestClassGroup, testBaseDir);
        }
        if (batchTestClassGroup instanceof JUnitBatchTestClassGroup) {
            return new JUnitAxisTestClassGroup((JUnitBatchTestClassGroup)batchTestClassGroup);
        }
        if (batchTestClassGroup instanceof PluginsGulpBatchTestClassGroup) {
            return new PluginsGulpAxisTestClassGroup((PluginsGulpBatchTestClassGroup)batchTestClassGroup);
        }
        return new AxisTestClassGroup(batchTestClassGroup);
    }

    public static BatchTestClassGroup newBatchTestClassGroup(String batchName, Job job) {
        Job.BuildProfile buildProfile = job.getBuildProfile();
        String key = JenkinsResultsParserUtil.combine(batchName, "_", buildProfile.toString(), "_", job.getJobName());
        if (_batchTestClassGroups.containsKey(key)) {
            return _batchTestClassGroups.get(key);
        }
        BatchTestClassGroup batchTestClassGroup = null;
        if (job instanceof PortalEnvironmentJob) {
            batchTestClassGroup = new EnvironmentFunctionalBatchTestClassGroup(batchName, (PortalEnvironmentJob)job);
        }
        if (batchTestClassGroup == null && job instanceof RootCauseAnalysisToolJob) {
            batchTestClassGroup = batchName.startsWith("functional-") ? new FunctionalRCABatchTestClassGroup(batchName, (RootCauseAnalysisToolJob)job) : (batchName.startsWith("integration-") || batchName.startsWith("modules-integration-") || batchName.startsWith("modules-unit-") || batchName.startsWith("unit-") ? new JUnitRCABatchTestClassGroup(batchName, (RootCauseAnalysisToolJob)job) : new RCABatchTestClassGroup(batchName, (RootCauseAnalysisToolJob)job));
        }
        if (batchTestClassGroup == null && job instanceof PortalTestClassJob) {
            PortalTestClassJob portalTestClassJob = (PortalTestClassJob)job;
            batchTestClassGroup = batchName.contains("cucumber-") ? new CucumberBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("functional-") || batchName.startsWith("modules-functional-") || batchName.startsWith("subrepository-functional-") ? new FunctionalBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("integration-") ? new IntegrationJUnitBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("js-test-") || batchName.startsWith("portal-frontend-js-") ? new NPMTestBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("js-unit-") ? new JSUnitModulesBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("junit-test-") || batchName.startsWith("modules-integration-project-templates-") || batchName.startsWith("modules-unit-project-templates-") ? new JUnitBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("modules-compile-") ? new CompileModulesBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("modules-integration-") && !batchName.startsWith("modules-integration-project-templates-") || batchName.startsWith("subrepository-integration-") ? new ModulesIntegrationJUnitBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("modules-unit-") && !batchName.startsWith("modules-unit-project-templates-") || batchName.startsWith("subrepository-unit-") ? new ModulesUnitJUnitBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("modules-semantic-versioning-") ? new SemVerModulesBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("plugins-compile-") ? new PluginsBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("plugins-functional-") ? new PluginsFunctionalBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("plugins-gulp-") ? new PluginsGulpBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("qa-websites-functional-") && job instanceof QAWebsitesGitRepositoryJob ? new QAWebsitesFunctionalBatchTestClassGroup(batchName, (QAWebsitesGitRepositoryJob)job) : (batchName.startsWith("rest-builder-") ? new RESTBuilderModulesBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("service-builder-") ? new ServiceBuilderModulesBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("tck-") ? new TCKJunitBatchTestClassGroup(batchName, portalTestClassJob) : (batchName.startsWith("unit-") ? new UnitJUnitBatchTestClassGroup(batchName, portalTestClassJob) : new DefaultBatchTestClassGroup(batchName, portalTestClassJob))))))))))))))))));
        }
        if (batchTestClassGroup == null) {
            throw new IllegalArgumentException("Unknown test class group");
        }
        _batchTestClassGroups.put(key, batchTestClassGroup);
        return batchTestClassGroup;
    }

    public static SegmentTestClassGroup newSegmentTestClassGroup(BatchTestClassGroup batchTestClassGroup) {
        if (batchTestClassGroup instanceof EnvironmentFunctionalBatchTestClassGroup) {
            return new EnvironmentFunctionalSegmentTestClassGroup((EnvironmentFunctionalBatchTestClassGroup)batchTestClassGroup);
        }
        if (batchTestClassGroup instanceof QAWebsitesFunctionalBatchTestClassGroup) {
            return new QAWebsitesFunctionalSegmentTestClassGroup((QAWebsitesFunctionalBatchTestClassGroup)batchTestClassGroup);
        }
        if (batchTestClassGroup instanceof FunctionalBatchTestClassGroup || batchTestClassGroup instanceof FunctionalRCABatchTestClassGroup) {
            Job job = batchTestClassGroup.getJob();
            if (job instanceof PortalAWSJob) {
                return new AWSFunctionalSegmentTestClassGroup(batchTestClassGroup);
            }
            return new FunctionalSegmentTestClassGroup(batchTestClassGroup);
        }
        if (batchTestClassGroup instanceof JUnitBatchTestClassGroup || batchTestClassGroup instanceof JUnitRCABatchTestClassGroup) {
            return new JUnitSegmentTestClassGroup(batchTestClassGroup);
        }
        if (batchTestClassGroup instanceof JSUnitModulesBatchTestClassGroup) {
            return new JSUnitModulesSegmentTestClassGroup(batchTestClassGroup);
        }
        if (batchTestClassGroup instanceof PluginsBatchTestClassGroup) {
            return new PluginsSegmentTestClassGroup((PluginsBatchTestClassGroup)batchTestClassGroup);
        }
        if (batchTestClassGroup instanceof PluginsGulpBatchTestClassGroup) {
            return new PluginsGulpSegmentTestClassGroup((PluginsGulpBatchTestClassGroup)batchTestClassGroup);
        }
        return new SegmentTestClassGroup(batchTestClassGroup);
    }
}

