/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.group.BaseTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.List;

public class TCKJunitBatchTestClassGroup
extends BatchTestClassGroup {
    private final File _tckHomeDir = this._getTCKHomeDir();

    @Override
    public int getAxisCount() {
        if (!this.isStableTestSuiteBatch() && this.testRelevantIntegrationUnitOnly) {
            return 0;
        }
        return super.getAxisCount();
    }

    protected TCKJunitBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
        this.excludesPathMatchers.addAll(this.getPathMatchers(this.getFirstPropertyValue("test.batch.class.names.excludes"), this._tckHomeDir));
        this.includesPathMatchers.addAll(this.getPathMatchers(this.getFirstPropertyValue("test.batch.class.names.includes"), this._tckHomeDir));
        if (this.includeStableTestSuite && this.isStableTestSuiteBatch()) {
            this.excludesPathMatchers.addAll(this.getPathMatchers(this.getFirstPropertyValue("test.batch.class.names.excludes", batchName, "stable"), this._tckHomeDir));
            this.includesPathMatchers.addAll(this.getPathMatchers(this.getFirstPropertyValue("test.batch.class.names.includes", batchName, "stable"), this._tckHomeDir));
        }
        this.setTestClasses();
        this.setAxisTestClassGroups();
        this.setSegmentTestClassGroups();
    }

    protected void setTestClasses() {
        try {
            Files.walkFileTree(this._tckHomeDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (JenkinsResultsParserUtil.isFileExcluded((List<PathMatcher>)TCKJunitBatchTestClassGroup.this.excludesPathMatchers, filePath.toFile())) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (JenkinsResultsParserUtil.isFileIncluded((List<PathMatcher>)TCKJunitBatchTestClassGroup.this.excludesPathMatchers, (List<PathMatcher>)TCKJunitBatchTestClassGroup.this.includesPathMatchers, filePath.toFile())) {
                        TCKJunitBatchTestClassGroup.this.testClasses.add(TCKBatchTestClass.getInstance(TCKJunitBatchTestClassGroup.this.batchName, filePath.toFile()));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to search for test file names in " + this._tckHomeDir.getPath(), ioException);
        }
        Collections.sort(this.testClasses);
    }

    private File _getTCKHomeDir() {
        File jenkinsDir;
        String tckHome = JenkinsResultsParserUtil.getProperty(this.jobProperties, "tck.home");
        if ((tckHome == null || tckHome.isEmpty()) && (jenkinsDir = new File("/opt/dev/projects/github/liferay-jenkins-ee")).exists()) {
            tckHome = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getProperties(new File(jenkinsDir, "commands/dependencies/test.properties")), "tck.home");
        }
        if (tckHome == null || tckHome.isEmpty()) {
            throw new RuntimeException("Unable find the TCK home");
        }
        return new File(tckHome);
    }

    public static class TCKBatchTestClass
    extends BaseTestClassGroup.BaseTestClass {
        protected static TCKBatchTestClass getInstance(String batchName, File warFile) {
            return new TCKBatchTestClass(batchName, new File(JenkinsResultsParserUtil.getCanonicalPath(warFile)));
        }

        protected TCKBatchTestClass(String batchName, File testClassFile) {
            super(testClassFile);
            this.addTestClassMethod(batchName);
        }
    }
}

