/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.group.ModulesBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ServiceBuilderModulesBatchTestClassGroup
extends ModulesBatchTestClassGroup {
    private BuildType _buildType;

    @Override
    public int getAxisCount() {
        if (!this.isStableTestSuiteBatch() && this.testRelevantIntegrationUnitOnly) {
            return 0;
        }
        if (this._buildType == BuildType.FULL || this.testClasses.isEmpty() && this._buildType == BuildType.CORE) {
            return 1;
        }
        return super.getAxisCount();
    }

    public BuildType getBuildType() {
        return this._buildType;
    }

    protected static List<File> getModulesProjectDirs(File moduleBaseDir) {
        final ArrayList<File> modulesProjectDirs = new ArrayList<File>();
        Path moduleBaseDirPath = moduleBaseDir.toPath();
        try {
            Files.walkFileTree(moduleBaseDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path filePath, BasicFileAttributes basicFileAttributes) {
                    File currentDirectory = filePath.toFile();
                    String filePathString = filePath.toString();
                    if (filePathString.endsWith("-service")) {
                        File buildFile = new File(currentDirectory, "build.gradle");
                        File serviceXmlFile = new File(currentDirectory, "service.xml");
                        if (buildFile.exists() && serviceXmlFile.exists()) {
                            modulesProjectDirs.add(currentDirectory);
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                    } else if (filePathString.endsWith("-portlet")) {
                        File portletXmlFile = new File(currentDirectory, "docroot/WEB-INF/portlet.xml");
                        File serviceXmlFile = new File(currentDirectory, "docroot/WEB-INF/service.xml");
                        if (portletXmlFile.exists() && serviceXmlFile.exists()) {
                            modulesProjectDirs.add(currentDirectory);
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get module marker files from " + moduleBaseDir.getPath(), ioException);
        }
        return modulesProjectDirs;
    }

    protected ServiceBuilderModulesBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
    }

    @Override
    protected void setAxisTestClassGroups() {
        int testClassCount = this.testClasses.size();
        int axisCount = this.getAxisCount();
        if (testClassCount == 0 && axisCount == 1) {
            this.axisTestClassGroups.add(0, TestClassGroupFactory.newAxisTestClassGroup(this));
            return;
        }
        super.setAxisTestClassGroups();
    }

    @Override
    protected void setTestClasses() throws IOException {
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        File portalModulesBaseDir = new File(portalGitWorkingDirectory.getWorkingDirectory(), "modules");
        if (!(!this.testRelevantChanges || this.includeStableTestSuite && this.isStableTestSuiteBatch())) {
            List<File> modifiedFiles = portalGitWorkingDirectory.getModifiedFilesList();
            List<File> modifiedPortalToolsServiceBuilderFiles = JenkinsResultsParserUtil.getIncludedFiles(null, this.getPathMatchers("util/portal-tools-service-builder/**", portalModulesBaseDir), modifiedFiles);
            if (!modifiedPortalToolsServiceBuilderFiles.isEmpty()) {
                this._buildType = BuildType.FULL;
                return;
            }
            List<File> modifiedPortalImplFiles = JenkinsResultsParserUtil.getIncludedFiles(null, this.getPathMatchers("portal-impl/**", portalGitWorkingDirectory.getWorkingDirectory()), modifiedFiles);
            if (!modifiedPortalImplFiles.isEmpty()) {
                this._buildType = BuildType.CORE;
            } else {
                List<File> modifiedPortalKernelFiles = JenkinsResultsParserUtil.getIncludedFiles(null, this.getPathMatchers("portal-kernel/**", portalGitWorkingDirectory.getWorkingDirectory()), modifiedFiles);
                if (!modifiedPortalKernelFiles.isEmpty()) {
                    this._buildType = BuildType.CORE;
                }
            }
        } else {
            this._buildType = BuildType.FULL;
            return;
        }
        this.moduleDirsList.addAll(portalGitWorkingDirectory.getModifiedModuleDirsList(this.excludesPathMatchers, this.includesPathMatchers));
        for (File moduleDir : this.moduleDirsList) {
            List<File> modulesProjectDirs = ServiceBuilderModulesBatchTestClassGroup.getModulesProjectDirs(moduleDir);
            if (modulesProjectDirs.isEmpty()) continue;
            this.testClasses.add(ServiceBuilderModulesBatchTestClass.getInstance(moduleDir, portalModulesBaseDir, modulesProjectDirs));
        }
        Collections.sort(this.testClasses);
    }

    public static class ServiceBuilderModulesBatchTestClass
    extends ModulesBatchTestClassGroup.ModulesBatchTestClass {
        protected static ServiceBuilderModulesBatchTestClass getInstance(File moduleBaseDir, File modulesDir, List<File> modulesProjectDirs) {
            return new ServiceBuilderModulesBatchTestClass(new File(JenkinsResultsParserUtil.getCanonicalPath(moduleBaseDir)), modulesDir, modulesProjectDirs);
        }

        protected ServiceBuilderModulesBatchTestClass(File testClassFile, File modulesDir, List<File> modulesProjectDirs) {
            super(testClassFile);
            this.initTestClassMethods(modulesProjectDirs, modulesDir, "buildService");
        }
    }

    public static enum BuildType {
        CORE,
        FULL;

    }
}

