/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.group.ModulesBatchTestClassGroup;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SemVerModulesBatchTestClassGroup
extends ModulesBatchTestClassGroup {
    @Override
    public int getAxisCount() {
        if (!this.isStableTestSuiteBatch() && this.testRelevantIntegrationUnitOnly) {
            return 0;
        }
        return super.getAxisCount();
    }

    protected static List<File> getModulesProjectDirs(File moduleBaseDir, File modulesDir) {
        final File baseDir = modulesDir;
        final ArrayList<File> modulesProjectDirs = new ArrayList<File>();
        Path moduleBaseDirPath = moduleBaseDir.toPath();
        try {
            Files.walkFileTree(moduleBaseDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path filePath, BasicFileAttributes basicFileAttributes) {
                    if (filePath.equals(baseDir.toPath())) {
                        return FileVisitResult.CONTINUE;
                    }
                    String filePathString = filePath.toString();
                    if (filePathString.endsWith("-test")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    File currentDirectory = filePath.toFile();
                    File bndBndFile = new File(currentDirectory, "bnd.bnd");
                    File buildFile = new File(currentDirectory, "build.gradle");
                    File lfrRelengIgnoreFile = new File(currentDirectory, ".lfrbuild-releng-ignore");
                    if (buildFile.exists() && bndBndFile.exists() && !lfrRelengIgnoreFile.exists()) {
                        modulesProjectDirs.add(currentDirectory);
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get module marker files from " + moduleBaseDir.getPath(), ioException);
        }
        return modulesProjectDirs;
    }

    protected SemVerModulesBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
    }

    @Override
    protected void setTestClasses() throws IOException {
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        File portalModulesBaseDir = new File(portalGitWorkingDirectory.getWorkingDirectory(), "modules");
        if (!(!this.testRelevantChanges || this.includeStableTestSuite && this.isStableTestSuiteBatch())) {
            this.moduleDirsList.addAll(portalGitWorkingDirectory.getModifiedModuleDirsList(this.excludesPathMatchers, this.includesPathMatchers));
        } else {
            this.moduleDirsList.addAll(portalGitWorkingDirectory.getModuleDirsList(this.excludesPathMatchers, this.includesPathMatchers));
            List<File> semVerMarkerFiles = JenkinsResultsParserUtil.findFiles(portalModulesBaseDir, "\\.lfrbuild-semantic-versioning");
            for (File semVerMarkerFile : semVerMarkerFiles) {
                this.moduleDirsList.add(semVerMarkerFile.getParentFile());
            }
        }
        for (File moduleDir : this.moduleDirsList) {
            List<File> modulesProjectDirs = SemVerModulesBatchTestClassGroup.getModulesProjectDirs(moduleDir, portalModulesBaseDir);
            if (modulesProjectDirs.isEmpty()) continue;
            this.testClasses.add(SemVerModulesBatchTestClass.getInstance(new File(JenkinsResultsParserUtil.getCanonicalPath(moduleDir)), portalModulesBaseDir, modulesProjectDirs));
        }
        Collections.sort(this.testClasses);
    }

    public static class SemVerModulesBatchTestClass
    extends ModulesBatchTestClassGroup.ModulesBatchTestClass {
        protected static SemVerModulesBatchTestClass getInstance(File moduleBaseDir, File modulesDir, List<File> modulesProjectDirs) {
            return new SemVerModulesBatchTestClass(new File(JenkinsResultsParserUtil.getCanonicalPath(moduleBaseDir)), modulesDir, modulesProjectDirs);
        }

        protected SemVerModulesBatchTestClass(File moduleBaseDir, File modulesDir, List<File> modulesProjectDirs) {
            super(moduleBaseDir);
            this.initTestClassMethods(modulesProjectDirs, modulesDir, "baseline");
        }
    }
}

