/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BaseTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SegmentTestClassGroup
extends BaseTestClassGroup {
    private final List<AxisTestClassGroup> _axisTestClassGroups = new ArrayList<AxisTestClassGroup>();
    private final BatchTestClassGroup _parentBatchTestClassGroup;

    public void addAxisTestClassGroup(AxisTestClassGroup axisTestClassGroup) {
        this._axisTestClassGroups.add(axisTestClassGroup);
        axisTestClassGroup.setSegmentTestClassGroup(this);
    }

    public int getAxisCount() {
        return this._axisTestClassGroups.size();
    }

    public AxisTestClassGroup getAxisTestClassGroup(int segmentIndex) {
        return this._axisTestClassGroups.get(segmentIndex);
    }

    public List<AxisTestClassGroup> getAxisTestClassGroups() {
        return new ArrayList<AxisTestClassGroup>(this._axisTestClassGroups);
    }

    public int getBatchIndex() {
        List<SegmentTestClassGroup> segmentTestClassGroups = this._parentBatchTestClassGroup.getSegmentTestClassGroups();
        return segmentTestClassGroups.indexOf(this);
    }

    public String getBatchJobName() {
        return this._parentBatchTestClassGroup.getBatchJobName();
    }

    public String getBatchName() {
        return this._parentBatchTestClassGroup.getBatchName();
    }

    @Override
    public Job getJob() {
        return this._parentBatchTestClassGroup.getJob();
    }

    public Integer getMaximumSlavesPerHost() {
        return this._parentBatchTestClassGroup.getMaximumSlavesPerHost();
    }

    public Integer getMinimumSlaveRAM() {
        return this._parentBatchTestClassGroup.getMinimumSlaveRAM();
    }

    public BatchTestClassGroup getParentBatchTestClassGroup() {
        return this._parentBatchTestClassGroup;
    }

    public String getSegmentName() {
        return JenkinsResultsParserUtil.combine(this.getBatchName(), "/", String.valueOf(this.getBatchIndex()));
    }

    public String getSlaveLabel() {
        BatchTestClassGroup batchTestClassGroup = this.getParentBatchTestClassGroup();
        return batchTestClassGroup.getSlaveLabel();
    }

    public File getTestBaseDir() {
        List<AxisTestClassGroup> axisTestClassGroups = this.getAxisTestClassGroups();
        if (axisTestClassGroups == null || axisTestClassGroups.isEmpty()) {
            return null;
        }
        AxisTestClassGroup axisTestClassGroup = axisTestClassGroups.get(0);
        return axisTestClassGroup.getTestBaseDir();
    }

    public String getTestCasePropertiesContent() {
        StringBuilder sb = new StringBuilder();
        File testBaseDir = this.getTestBaseDir();
        if (testBaseDir != null && testBaseDir.exists()) {
            sb.append("TEST_BASE_DIR_NAME=");
            sb.append(JenkinsResultsParserUtil.getCanonicalPath(testBaseDir));
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public List<TestClassGroup.TestClass> getTestClasses() {
        ArrayList<TestClassGroup.TestClass> testClasses = new ArrayList<TestClassGroup.TestClass>();
        for (AxisTestClassGroup axisTestClassGroup : this.getAxisTestClassGroups()) {
            testClasses.addAll(axisTestClassGroup.getTestClasses());
        }
        return testClasses;
    }

    protected SegmentTestClassGroup(BatchTestClassGroup parentBatchTestClassGroup) {
        this._parentBatchTestClassGroup = parentBatchTestClassGroup;
    }
}

