/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.QAWebsitesGitRepositoryJob;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalBatchTestClassGroup;
import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.util.PropsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class QAWebsitesFunctionalBatchTestClassGroup
extends FunctionalBatchTestClassGroup {
    @Override
    public List<File> getTestBaseDirs() {
        ArrayList<File> testBaseDirs = new ArrayList<File>();
        QAWebsitesGitRepositoryJob qaWebsitesGitRepositoryJob = this._getQAWebsitesGitRepositoryJob();
        GitWorkingDirectory qaWebsitesGitWorkingDirectory = this._getQAWebsitesGitWorkingDirectory();
        for (String projectName : qaWebsitesGitRepositoryJob.getProjectNames()) {
            testBaseDirs.add(new File(qaWebsitesGitWorkingDirectory.getWorkingDirectory(), projectName));
        }
        return testBaseDirs;
    }

    protected QAWebsitesFunctionalBatchTestClassGroup(String batchName, QAWebsitesGitRepositoryJob qaWebsitesGitRepositoryJob) {
        super(batchName, qaWebsitesGitRepositoryJob);
    }

    @Override
    protected String getDefaultTestBatchRunPropertyQuery(File testBaseDir, String testSuiteName) {
        File testPropertiesFile;
        String query = System.getenv("TEST_QA_WEBSITES_PROPERTY_QUERY");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(query)) {
            return query;
        }
        Properties testProperties = new Properties(this.jobProperties);
        if (testBaseDir != null && testBaseDir.exists() && (testPropertiesFile = new File(testBaseDir, "test.properties")).exists()) {
            testProperties.putAll((Map<?, ?>)JenkinsResultsParserUtil.getProperties(testPropertiesFile));
        }
        return JenkinsResultsParserUtil.getProperty(testProperties, "test.batch.property.query", testBaseDir.getName(), testSuiteName);
    }

    @Override
    protected List<List<String>> getPoshiTestClassGroups(File testBaseDir) {
        String query = this.getTestBatchRunPropertyQuery(testBaseDir);
        if (JenkinsResultsParserUtil.isNullOrEmpty(query)) {
            return new ArrayList<List<String>>();
        }
        PortalTestClassJob portalTestClassJob = this.portalTestClassJob;
        synchronized (portalTestClassJob) {
            String testBaseDirPath = null;
            if (testBaseDir != null && testBaseDir.exists()) {
                testBaseDirPath = JenkinsResultsParserUtil.getCanonicalPath(testBaseDir);
            }
            Properties properties = JenkinsResultsParserUtil.getProperties(new File(testBaseDir.getParentFile(), "test.properties"), new File(testBaseDir, "test.properties"));
            properties.setProperty("ignore.errors.util.classes", "true");
            if (!JenkinsResultsParserUtil.isNullOrEmpty(testBaseDirPath)) {
                properties.setProperty("test.base.dir.name", testBaseDirPath);
            }
            PropsUtil.clear();
            PropsUtil.setProperties((Properties)properties);
            try {
                PoshiContext.clear();
                PoshiContext.readFiles();
                return PoshiContext.getTestBatchGroups((String)query, (int)this.getAxisMaxSize());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private QAWebsitesGitRepositoryJob _getQAWebsitesGitRepositoryJob() {
        if (!(this.portalTestClassJob instanceof QAWebsitesGitRepositoryJob)) {
            throw new RuntimeException("Invalid job type " + this.portalTestClassJob);
        }
        return (QAWebsitesGitRepositoryJob)this.portalTestClassJob;
    }

    private GitWorkingDirectory _getQAWebsitesGitWorkingDirectory() {
        QAWebsitesGitRepositoryJob qaWebsitesGitRepositoryJob = this._getQAWebsitesGitRepositoryJob();
        return qaWebsitesGitRepositoryJob.getGitWorkingDirectory();
    }
}

