/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.PluginsGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.group.BaseTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PluginsGulpBatchTestClassGroup
extends BatchTestClassGroup {
    private final List<File> _modifiedFilesList;

    public List<File> getTestBaseDirNames() {
        ArrayList<File> testBaseDirNames = new ArrayList<File>();
        for (File modifiedFile : this._modifiedFilesList) {
            for (File parentDir = new File(modifiedFile.getPath()); parentDir != null; parentDir = parentDir.getParentFile()) {
                File gulpFile = new File(parentDir, "gulpfile.js");
                if (!gulpFile.exists()) continue;
                testBaseDirNames.add(gulpFile.getParentFile());
            }
        }
        return testBaseDirNames;
    }

    protected PluginsGulpBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
        this._modifiedFilesList = this.portalGitWorkingDirectory.getModifiedFilesList();
        PluginsGitWorkingDirectory pluginsGitWorkingDirectory = this.portalGitWorkingDirectory.getPluginsGitWorkingDirectory();
        this._modifiedFilesList.addAll(pluginsGitWorkingDirectory.getModifiedFilesList());
        this._setTestClasses();
        this.setAxisTestClassGroups();
        this.setSegmentTestClassGroups();
    }

    @Override
    protected int getAxisMaxSize() {
        return 1;
    }

    @Override
    protected int getSegmentMaxChildren() {
        return 1;
    }

    private void _setTestClasses() {
        for (File testBaseDirName : this.getTestBaseDirNames()) {
            this.testClasses.add(new PluginsGulpBatchTestClass(testBaseDirName));
        }
        Collections.sort(this.testClasses);
    }

    public static class PluginsGulpBatchTestClass
    extends BaseTestClassGroup.BaseTestClass {
        protected PluginsGulpBatchTestClass(File testBaseDirName) {
            super(testBaseDirName);
            this.addTestClassMethod("gulpfile.js");
        }
    }
}

