/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.AntException;
import com.liferay.jenkins.results.parser.AntUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PluginsGitRepositoryJob;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalBatchTestClassGroup;
import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.util.PropsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PluginsFunctionalBatchTestClassGroup
extends FunctionalBatchTestClassGroup {
    private static final Pattern _pattern = Pattern.compile(".*/portlets/(?<portletName>[^/]+-portlet)/.*");

    @Override
    public List<File> getTestBaseDirs() {
        if (!(this.portalTestClassJob instanceof PluginsGitRepositoryJob)) {
            return new ArrayList<File>();
        }
        PluginsGitRepositoryJob pluginsGitRepositoryJob = (PluginsGitRepositoryJob)this.portalTestClassJob;
        return pluginsGitRepositoryJob.getPluginsTestBaseDirs();
    }

    protected PluginsFunctionalBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
    }

    @Override
    protected String getDefaultTestBatchRunPropertyQuery(File testBaseDir, String testSuiteName) {
        File testPropertiesFile;
        String propertyQuery = System.getenv("TEST_BATCH_RUN_PROPERTY_QUERY");
        if (propertyQuery != null && !propertyQuery.isEmpty()) {
            return propertyQuery;
        }
        Properties testProperties = new Properties(this.jobProperties);
        if (testBaseDir != null && testBaseDir.exists() && (testPropertiesFile = new File(testBaseDir, "test.properties")).exists()) {
            testProperties.putAll((Map<?, ?>)JenkinsResultsParserUtil.getProperties(testPropertiesFile));
        }
        return JenkinsResultsParserUtil.getProperty(testProperties, "test.batch.run.property.query", this._getPortletName(testBaseDir), testSuiteName, this.batchName, this.getJobName());
    }

    @Override
    protected List<List<String>> getPoshiTestClassGroups(File testBaseDir) {
        String query = this.getTestBatchRunPropertyQuery(testBaseDir);
        if (JenkinsResultsParserUtil.isNullOrEmpty(query)) {
            return new ArrayList<List<String>>();
        }
        PortalTestClassJob portalTestClassJob = this.portalTestClassJob;
        synchronized (portalTestClassJob) {
            PortalGitWorkingDirectory portalGitWorkingDirectory = this.portalTestClassJob.getPortalGitWorkingDirectory();
            File portalWorkingDirectory = portalGitWorkingDirectory.getWorkingDirectory();
            HashMap<String, String> parameters = new HashMap<String, String>();
            String testBaseDirPath = null;
            if (testBaseDir != null && testBaseDir.exists()) {
                testBaseDirPath = JenkinsResultsParserUtil.getCanonicalPath(testBaseDir);
                parameters.put("test.base.dir.name", testBaseDirPath);
            }
            try {
                AntUtil.callTarget(portalWorkingDirectory, "build-test.xml", "prepare-poshi-runner-properties", parameters);
            }
            catch (AntException antException) {
                throw new RuntimeException(antException);
            }
            Properties properties = JenkinsResultsParserUtil.getProperties(new File(portalWorkingDirectory, "portal-web/test/test-portal-web.properties"), new File(portalWorkingDirectory, "portal-web/test/test-portal-web-ext.properties"), new File(testBaseDir, "test.properties"));
            properties.setProperty("ignore.errors.util.classes", "true");
            if (!JenkinsResultsParserUtil.isNullOrEmpty(testBaseDirPath)) {
                properties.setProperty("test.base.dir.name", testBaseDirPath);
            }
            PropsUtil.clear();
            PropsUtil.setProperties((Properties)properties);
            try {
                PoshiContext.clear();
                PoshiContext.readFiles();
                return PoshiContext.getTestBatchGroups((String)query, (int)this.getAxisMaxSize());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private String _getPortletName(File testBaseDir) {
        String testBaseDirPath = JenkinsResultsParserUtil.getCanonicalPath(testBaseDir);
        if (JenkinsResultsParserUtil.isNullOrEmpty(testBaseDirPath)) {
            return null;
        }
        Matcher matcher = _pattern.matcher(testBaseDirPath);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group("portletName");
    }
}

