/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PluginsGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.group.BaseTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.List;

public class PluginsBatchTestClassGroup
extends BatchTestClassGroup {
    private final PluginsGitWorkingDirectory _pluginsGitWorkingDirectory;

    @Override
    public int getAxisCount() {
        if (!this.isStableTestSuiteBatch() && this.testRelevantIntegrationUnitOnly) {
            return 0;
        }
        return super.getAxisCount();
    }

    protected PluginsBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
        this._pluginsGitWorkingDirectory = this.portalGitWorkingDirectory.getPluginsGitWorkingDirectory();
        this.excludesPathMatchers.addAll(this.getPathMatchers(this.getFirstPropertyValue("test.batch.plugin.names.excludes"), this._pluginsGitWorkingDirectory.getWorkingDirectory()));
        this.includesPathMatchers.addAll(this.getPathMatchers(this.getFirstPropertyValue("test.batch.plugin.names.includes"), this._pluginsGitWorkingDirectory.getWorkingDirectory()));
        if (this.includeStableTestSuite && this.isStableTestSuiteBatch()) {
            this.excludesPathMatchers.addAll(this.getPathMatchers(this.getFirstPropertyValue("test.batch.plugin.names.excludes", batchName, "stable"), this._pluginsGitWorkingDirectory.getWorkingDirectory()));
            this.includesPathMatchers.addAll(this.getPathMatchers(this.getFirstPropertyValue("test.batch.plugin.names.includes", batchName, "stable"), this._pluginsGitWorkingDirectory.getWorkingDirectory()));
        }
        this.setTestClasses();
        this.setAxisTestClassGroups();
        this.setSegmentTestClassGroups();
    }

    protected void setTestClasses() {
        File workingDirectory = this._pluginsGitWorkingDirectory.getWorkingDirectory();
        try {
            Files.walkFileTree(workingDirectory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (JenkinsResultsParserUtil.isFileExcluded((List<PathMatcher>)PluginsBatchTestClassGroup.this.excludesPathMatchers, filePath)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (JenkinsResultsParserUtil.isFileIncluded((List<PathMatcher>)PluginsBatchTestClassGroup.this.excludesPathMatchers, (List<PathMatcher>)PluginsBatchTestClassGroup.this.includesPathMatchers, filePath)) {
                        File file = filePath.toFile();
                        PluginsBatchTestClassGroup.this.testClasses.add(PluginsBatchTestClass.getInstance(PluginsBatchTestClassGroup.this.batchName, file.getParentFile()));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to search for test file names in " + workingDirectory.getPath(), ioException);
        }
        Collections.sort(this.testClasses);
    }

    public static class PluginsBatchTestClass
    extends BaseTestClassGroup.BaseTestClass {
        protected static PluginsBatchTestClass getInstance(String batchName, File pluginDir) {
            return new PluginsBatchTestClass(batchName, new File(JenkinsResultsParserUtil.getCanonicalPath(pluginDir)));
        }

        protected PluginsBatchTestClass(String batchName, File testClassFile) {
            super(testClassFile);
            this.addTestClassMethod(batchName);
        }
    }
}

