/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.google.common.collect.Lists;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.group.JUnitBatchTestClassGroup;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModulesJUnitBatchTestClassGroup
extends JUnitBatchTestClassGroup {
    private static final Pattern _singleModuleBatchNamePattern = Pattern.compile("modules-unit-(?<moduleName>\\S+)-jdk\\d+");

    @Override
    public int getAxisCount() {
        return super.getAxisCount();
    }

    protected ModulesJUnitBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
    }

    @Override
    protected List<String> getReleaseTestClassNamesRelativeIncludesGlobs(List<String> testClassNamesRelativeIncludesGlobs) {
        Set<File> releaseModuleAppDirs = this._getReleaseModuleAppDirs();
        if (releaseModuleAppDirs.isEmpty()) {
            return testClassNamesRelativeIncludesGlobs;
        }
        ArrayList<String> testClassNameRelativeIncludesGlobs = new ArrayList<String>();
        for (File releaseModuleAppDir : releaseModuleAppDirs) {
            String releaseModuleAppAbsolutePath = JenkinsResultsParserUtil.getCanonicalPath(releaseModuleAppDir);
            String appSourceRelativePath = releaseModuleAppAbsolutePath.substring(releaseModuleAppAbsolutePath.indexOf("modules/"));
            for (String testClassNamesRelativeGlob : testClassNamesRelativeIncludesGlobs) {
                testClassNameRelativeIncludesGlobs.add(JenkinsResultsParserUtil.combine(appSourceRelativePath, "/", testClassNamesRelativeGlob));
                if (!testClassNamesRelativeGlob.startsWith("**/")) continue;
                testClassNameRelativeIncludesGlobs.add(JenkinsResultsParserUtil.combine(appSourceRelativePath, "/", testClassNamesRelativeGlob.substring(3)));
            }
        }
        return testClassNameRelativeIncludesGlobs;
    }

    @Override
    protected List<String> getRelevantTestClassNamesRelativeExcludesGlobs() {
        HashSet<File> modifiedModuleDirsList = new HashSet<File>();
        try {
            modifiedModuleDirsList.addAll(this.portalGitWorkingDirectory.getModifiedModuleDirsList());
        }
        catch (IOException ioException) {
            File workingDirectory = this.portalGitWorkingDirectory.getWorkingDirectory();
            throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to get relevant module group directories in ", workingDirectory.getPath()), ioException);
        }
        ArrayList<String> relevantTestClassNameRelativeExcludesGlobs = new ArrayList<String>();
        for (File modifiedModuleDir : modifiedModuleDirsList) {
            String firstMatchingPropertyName;
            String modulesTestBatchClassNamesExcludes = null;
            File modifiedDirTestProperties = new File(modifiedModuleDir, "test.properties");
            Properties testProperties = JenkinsResultsParserUtil.getProperties(modifiedDirTestProperties);
            if (modifiedDirTestProperties.exists() && (firstMatchingPropertyName = this.getFirstMatchingPropertyName("modules.includes.required.test.batch.class.names.excludes", testProperties, this.testSuiteName)) != null) {
                modulesTestBatchClassNamesExcludes = JenkinsResultsParserUtil.getProperty(testProperties, firstMatchingPropertyName);
            }
            if (modulesTestBatchClassNamesExcludes == null) continue;
            for (String modulesTestBatchClassNamesExclude : JenkinsResultsParserUtil.getGlobsFromProperty(modulesTestBatchClassNamesExcludes)) {
                relevantTestClassNameRelativeExcludesGlobs.add(JenkinsResultsParserUtil.combine("modules/", modulesTestBatchClassNamesExclude));
            }
        }
        return relevantTestClassNameRelativeExcludesGlobs;
    }

    @Override
    protected List<String> getRelevantTestClassNamesRelativeIncludesGlobs(List<String> testClassNamesRelativeIncludesGlobs) {
        HashSet<File> modifiedModuleDirsList = new HashSet<File>();
        try {
            modifiedModuleDirsList.addAll(this.portalGitWorkingDirectory.getModifiedModuleDirsList());
        }
        catch (IOException ioException) {
            File workingDirectory = this.portalGitWorkingDirectory.getWorkingDirectory();
            throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to get relevant module group directories in ", workingDirectory.getPath()), ioException);
        }
        ArrayList<String> relevantTestClassNameRelativeIncludesGlobs = new ArrayList<String>();
        if (this.testRelevantChanges) {
            modifiedModuleDirsList.addAll(this.getRequiredModuleDirs(Lists.newArrayList(modifiedModuleDirsList)));
        }
        Matcher matcher = _singleModuleBatchNamePattern.matcher(this.batchName);
        String moduleName = null;
        if (matcher.find()) {
            moduleName = matcher.group("moduleName");
        }
        for (File modifiedModuleDir : modifiedModuleDirsList) {
            Properties testProperties;
            String firstMatchingPropertyName;
            String modifiedModuleAbsolutePath = JenkinsResultsParserUtil.getCanonicalPath(modifiedModuleDir);
            String modifiedModuleRelativePath = modifiedModuleAbsolutePath.substring(modifiedModuleAbsolutePath.indexOf("modules/"));
            if (moduleName != null && !modifiedModuleRelativePath.contains("/" + moduleName)) continue;
            for (String testClassNamesRelativeGlob : testClassNamesRelativeIncludesGlobs) {
                relevantTestClassNameRelativeIncludesGlobs.add(JenkinsResultsParserUtil.combine(modifiedModuleRelativePath, "/", testClassNamesRelativeGlob));
                if (!testClassNamesRelativeGlob.startsWith("**/")) continue;
                relevantTestClassNameRelativeIncludesGlobs.add(JenkinsResultsParserUtil.combine(modifiedModuleRelativePath, "/", testClassNamesRelativeGlob.substring(3)));
            }
            String modulesTestBatchClassNamesIncludes = null;
            File modifiedDirTestProperties = new File(modifiedModuleDir, "test.properties");
            if (modifiedDirTestProperties.exists() && (firstMatchingPropertyName = this.getFirstMatchingPropertyName("modules.includes.required.test.batch.class.names.includes", testProperties = JenkinsResultsParserUtil.getProperties(modifiedDirTestProperties), this.testSuiteName)) != null) {
                modulesTestBatchClassNamesIncludes = JenkinsResultsParserUtil.getProperty(testProperties, firstMatchingPropertyName);
            }
            if (modulesTestBatchClassNamesIncludes == null) continue;
            for (String modulesTestBatchClassNamesInclude : JenkinsResultsParserUtil.getGlobsFromProperty(modulesTestBatchClassNamesIncludes)) {
                relevantTestClassNameRelativeIncludesGlobs.add(JenkinsResultsParserUtil.combine("modules/", modulesTestBatchClassNamesInclude));
            }
        }
        return relevantTestClassNameRelativeIncludesGlobs;
    }

    @Override
    protected void setTestClassNamesExcludesRelativeGlobs() {
        super.setTestClassNamesExcludesRelativeGlobs();
        if (!this.testRelevantChanges) {
            List<File> modulePullSubrepoDirs = this.portalGitWorkingDirectory.getModulePullSubrepoDirs();
            for (File modulePullSubrepoDir : modulePullSubrepoDirs) {
                this.testClassNamesExcludesPathMatchers.addAll(JenkinsResultsParserUtil.toPathMatchers(modulePullSubrepoDir.getAbsolutePath(), "/**"));
            }
        }
    }

    private String _getAppTitle(File appBndFile) {
        Properties appBndProperties = JenkinsResultsParserUtil.getProperties(appBndFile);
        String appTitle = appBndProperties.getProperty("Liferay-Releng-App-Title");
        return appTitle.replace("${liferay.releng.app.title.prefix}", this._getAppTitlePrefix());
    }

    private String _getAppTitlePrefix() {
        String portalBranchName = this.portalGitWorkingDirectory.getUpstreamBranchName();
        if (portalBranchName.contains("-private")) {
            return "Liferay";
        }
        return "Liferay CE";
    }

    private Set<String> _getBundledAppNames() {
        HashSet<String> bundledAppNames = new HashSet<String>();
        File liferayHome = this._getLiferayHome();
        if (liferayHome == null || !liferayHome.exists()) {
            return bundledAppNames;
        }
        List<File> bundledApps = JenkinsResultsParserUtil.findFiles(liferayHome, ".*\\.lpkg");
        for (File bundledApp : bundledApps) {
            String bundledAppName = bundledApp.getName();
            bundledAppNames.add(bundledAppName);
        }
        return bundledAppNames;
    }

    private File _getLiferayHome() {
        Properties buildProperties = JenkinsResultsParserUtil.getProperties(new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "build.properties"));
        String liferayHomePath = buildProperties.getProperty("liferay.home");
        if (liferayHomePath == null) {
            return null;
        }
        return new File(liferayHomePath);
    }

    private Set<File> _getReleaseModuleAppDirs() {
        Set<String> bundledAppNames = this._getBundledAppNames();
        HashSet<File> releaseModuleAppDirs = new HashSet<File>();
        for (File moduleAppDir : this.portalGitWorkingDirectory.getModuleAppDirs()) {
            File appBndFile = new File(moduleAppDir, "app.bnd");
            String appTitle = this._getAppTitle(appBndFile);
            for (String bundledAppName : bundledAppNames) {
                String regex = JenkinsResultsParserUtil.combine("((.* - )?", Pattern.quote(appTitle), " -.*|", Pattern.quote(appTitle), ")\\.lpkg");
                if (!bundledAppName.matches(regex)) continue;
                List<File> skipTestIntegrationCheckFiles = JenkinsResultsParserUtil.findFiles(moduleAppDir, ".lfrbuild-ci-skip-test-integration-check");
                if (!skipTestIntegrationCheckFiles.isEmpty()) {
                    System.out.println("Ignoring " + moduleAppDir);
                    continue;
                }
                releaseModuleAppDirs.add(moduleAppDir);
            }
        }
        return releaseModuleAppDirs;
    }
}

