/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.group.BaseTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class ModulesBatchTestClassGroup
extends BatchTestClassGroup {
    protected Set<File> moduleDirsList = new HashSet<File>();

    @Override
    public int getAxisCount() {
        if (!this.isStableTestSuiteBatch() && this.testRelevantIntegrationUnitOnly) {
            return 0;
        }
        return super.getAxisCount();
    }

    protected ModulesBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
        try {
            File modulesDir = new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "modules");
            String upstreamBranchName = this.portalGitWorkingDirectory.getUpstreamBranchName();
            if (upstreamBranchName.startsWith("ee-") || upstreamBranchName.endsWith("-private")) {
                this.excludesPathMatchers.addAll(this.getPathMatchers(this.getFirstPropertyValue("modules.excludes.private"), modulesDir));
                this.includesPathMatchers.addAll(this.getPathMatchers(this.getFirstPropertyValue("modules.includes.private"), modulesDir));
                if (this.includeStableTestSuite && this.isStableTestSuiteBatch()) {
                    this.excludesPathMatchers.addAll(this.getPathMatchers(this.getFirstPropertyValue("modules.excludes.private", batchName, "stable"), modulesDir));
                    this.includesPathMatchers.addAll(this.getPathMatchers(this.getFirstPropertyValue("modules.includes.private", batchName, "stable"), modulesDir));
                }
            } else {
                this.excludesPathMatchers.addAll(this.getPathMatchers(this.getFirstPropertyValue("modules.excludes.public"), modulesDir));
                this.includesPathMatchers.addAll(this.getPathMatchers(this.getFirstPropertyValue("modules.includes.public"), modulesDir));
                if (this.includeStableTestSuite && this.isStableTestSuiteBatch()) {
                    this.excludesPathMatchers.addAll(this.getPathMatchers(this.getFirstPropertyValue("modules.excludes.public", batchName, "stable"), modulesDir));
                    this.includesPathMatchers.addAll(this.getPathMatchers(this.getFirstPropertyValue("modules.includes.public", batchName, "stable"), modulesDir));
                }
            }
            Job.BuildProfile buildProfile = portalTestClassJob.getBuildProfile();
            this.excludesPathMatchers.addAll(this.getPathMatchers(this.getFirstPropertyValue("modules.excludes." + (Object)((Object)buildProfile)), modulesDir));
            if (this.testRelevantChanges) {
                this.moduleDirsList.addAll(this.getRequiredModuleDirs(this.portalGitWorkingDirectory.getModifiedModuleDirsList(this.excludesPathMatchers, this.includesPathMatchers)));
            }
            this.setTestClasses();
            this.setAxisTestClassGroups();
            this.setSegmentTestClassGroups();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected abstract void setTestClasses() throws IOException;

    public static class ModulesBatchTestClass
    extends BaseTestClassGroup.BaseTestClass {
        protected ModulesBatchTestClass(File moduleBaseDir) {
            super(moduleBaseDir);
        }

        protected void initTestClassMethods(List<File> modulesProjectDirs, File modulesDir, String taskName) {
            for (File modulesProjectDir : modulesProjectDirs) {
                String path = JenkinsResultsParserUtil.getPathRelativeTo(modulesProjectDir, modulesDir);
                String moduleTaskCall = JenkinsResultsParserUtil.combine(":", path.replaceAll("/", ":"), ":", taskName);
                this.addTestClassMethod(moduleTaskCall);
            }
        }
    }
}

