/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.google.common.collect.Lists;
import com.liferay.jenkins.results.parser.CentralMergePullRequestJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BaseTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JUnitBatchTestClassGroup
extends BatchTestClassGroup {
    protected final List<PathMatcher> testClassNamesExcludesPathMatchers = new ArrayList<PathMatcher>();
    protected final List<PathMatcher> testClassNamesIncludesPathMatchers = new ArrayList<PathMatcher>();
    private static final boolean _ENABLE_INCLUDE_AUTO_BALANCE_TESTS_DEFAULT = false;
    private static final String _GLOB_MODULES_PRIVATE = "modules/private/**";
    private final List<File> _autoBalanceTestFiles = new ArrayList<File>();
    private boolean _includeAutoBalanceTests;
    private final boolean _includeUnstagedTestClassFiles;
    private final File _rootWorkingDirectory;

    @Override
    public int getAxisCount() {
        int axisCount = super.getAxisCount();
        if (axisCount == 0 && this._includeAutoBalanceTests) {
            return 1;
        }
        return axisCount;
    }

    public Map<File, JunitBatchTestClass> getJunitTestClasses() {
        return JunitBatchTestClass.getJunitTestClasses();
    }

    public void writeTestCSVReportFile() throws Exception {
        BatchTestClassGroup.CSVReport csvReport = new BatchTestClassGroup.CSVReport(new BatchTestClassGroup.CSVReport.Row("Class Name", "Method Name", "Ignored", "File Path"));
        Map<File, JunitBatchTestClass> junitTestClasses = this.getJunitTestClasses();
        for (JunitBatchTestClass junitBatchTestClass : junitTestClasses.values()) {
            File testClassFile = junitBatchTestClass.getTestClassFile();
            String testClassFileRelativePath = this._getRelativePath(testClassFile, junitBatchTestClass.getWorkingDirectory());
            String className = testClassFile.getName();
            className = className.replace(".class", "");
            List<TestClassGroup.TestClass.TestClassMethod> testClassMethods = junitBatchTestClass.getTestClassMethods();
            for (TestClassGroup.TestClass.TestClassMethod testClassMethod : testClassMethods) {
                BatchTestClassGroup.CSVReport.Row csvReportRow = new BatchTestClassGroup.CSVReport.Row();
                csvReportRow.add(className);
                csvReportRow.add(testClassMethod.getName());
                if (testClassMethod.isIgnored()) {
                    csvReportRow.add("TRUE");
                } else {
                    csvReportRow.add("");
                }
                csvReportRow.add(testClassFileRelativePath);
                csvReport.addRow(csvReportRow);
            }
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy");
        File csvReportFile = new File(JenkinsResultsParserUtil.combine("Report_junit_", simpleDateFormat.format(new Date()), ".csv"));
        try {
            JenkinsResultsParserUtil.write(csvReportFile, csvReport.toString());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected JUnitBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
        this._includeUnstagedTestClassFiles = portalTestClassJob instanceof CentralMergePullRequestJob;
        PortalGitWorkingDirectory portalGitWorkingDirectory = portalTestClassJob.getPortalGitWorkingDirectory();
        this._rootWorkingDirectory = portalGitWorkingDirectory.getWorkingDirectory();
        this._setAutoBalanceTestFiles();
        this.setTestClassNamesExcludesRelativeGlobs();
        this._setTestClassNamesIncludesRelativeGlobs();
        this.setTestClasses();
        this._setIncludeAutoBalanceTests();
        this.setAxisTestClassGroups();
        this.setSegmentTestClassGroups();
    }

    protected List<String> getReleaseTestClassNamesRelativeIncludesGlobs(List<String> testClassNamesRelativeIncludesGlobs) {
        return testClassNamesRelativeIncludesGlobs;
    }

    protected List<String> getRelevantTestClassNamesRelativeExcludesGlobs() {
        return new ArrayList<String>();
    }

    protected List<String> getRelevantTestClassNamesRelativeIncludesGlobs(List<String> testClassNamesRelativeIncludesGlobs) {
        List<File> moduleDirsList = null;
        try {
            moduleDirsList = this.portalGitWorkingDirectory.getModuleDirsList();
        }
        catch (IOException ioException) {
            File workingDirectory = this.portalGitWorkingDirectory.getWorkingDirectory();
            throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to get module directories in ", workingDirectory.getPath()), ioException);
        }
        ArrayList<String> relevantTestClassNameRelativeIncludesGlobs = new ArrayList<String>();
        List<File> modifiedFilesList = this.portalGitWorkingDirectory.getModifiedFilesList();
        for (File modifiedFile : modifiedFilesList) {
            boolean foundModuleFile = false;
            for (File moduleDir : moduleDirsList) {
                if (!JenkinsResultsParserUtil.isFileInDirectory(moduleDir, modifiedFile)) continue;
                foundModuleFile = true;
                break;
            }
            if (foundModuleFile) continue;
            relevantTestClassNameRelativeIncludesGlobs.addAll(testClassNamesRelativeIncludesGlobs);
            return relevantTestClassNameRelativeIncludesGlobs;
        }
        return relevantTestClassNameRelativeIncludesGlobs;
    }

    protected boolean isValidTestClass(TestClassGroup.TestClass testClass) {
        return true;
    }

    @Override
    protected void setAxisTestClassGroups() {
        int axisCount = this.getAxisCount();
        if (axisCount == 0) {
            return;
        }
        int testClassCount = this.testClasses.size();
        if (testClassCount == 0) {
            if (!this._includeAutoBalanceTests) {
                return;
            }
            this.axisTestClassGroups.add(0, TestClassGroupFactory.newAxisTestClassGroup(this));
        } else {
            int axisSize = (int)Math.ceil((double)testClassCount / (double)axisCount);
            for (List axisTestClasses : Lists.partition((List)this.testClasses, (int)axisSize)) {
                AxisTestClassGroup axisTestClassGroup = TestClassGroupFactory.newAxisTestClassGroup(this);
                for (TestClassGroup.TestClass axisTestClass : axisTestClasses) {
                    axisTestClassGroup.addTestClass(axisTestClass);
                }
                this.axisTestClassGroups.add(axisTestClassGroup);
            }
        }
        if (!this._includeAutoBalanceTests) {
            return;
        }
        for (int i = 0; i < axisCount; ++i) {
            AxisTestClassGroup axisTestClassGroup = (AxisTestClassGroup)this.axisTestClassGroups.get(i);
            for (File autoBalanceTestFile : this._autoBalanceTestFiles) {
                String filePath = autoBalanceTestFile.getPath();
                filePath = filePath.replace(".java", ".class");
                axisTestClassGroup.addTestClass(JunitBatchTestClass.getInstance(new File(filePath), this.portalGitWorkingDirectory, autoBalanceTestFile));
            }
        }
    }

    protected void setTestClasses() {
        if (this.testClassNamesIncludesPathMatchers.isEmpty()) {
            return;
        }
        try {
            Files.walkFileTree(this._rootWorkingDirectory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (JenkinsResultsParserUtil.isFileExcluded(JUnitBatchTestClassGroup.this.testClassNamesExcludesPathMatchers, filePath.toFile())) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (JenkinsResultsParserUtil.isFileIncluded(JUnitBatchTestClassGroup.this.testClassNamesExcludesPathMatchers, JUnitBatchTestClassGroup.this.testClassNamesIncludesPathMatchers, filePath.toFile())) {
                        BaseTestClassGroup.BaseTestClass testClass = this._getPackagePathClassFile(filePath);
                        if (testClass.isIgnored()) {
                            return FileVisitResult.CONTINUE;
                        }
                        List<TestClassGroup.TestClass.TestClassMethod> testClassMethods = testClass.getTestClassMethods();
                        if (!testClassMethods.isEmpty() && JUnitBatchTestClassGroup.this.isValidTestClass(testClass)) {
                            JUnitBatchTestClassGroup.this.testClasses.add(testClass);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                private BaseTestClassGroup.BaseTestClass _getPackagePathClassFile(Path path) {
                    return JunitBatchTestClass.getInstance(path.toFile(), JUnitBatchTestClassGroup.this.portalGitWorkingDirectory, path.toFile());
                }
            });
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to search for test file names in " + this._rootWorkingDirectory.getPath(), ioException);
        }
        Collections.sort(this.testClasses);
    }

    protected void setTestClassNamesExcludesRelativeGlobs() {
        String stableTestClassNamesExcludesPropertyValue;
        String testClassNamesExcludesPropertyValue = this._getTestClassNamesExcludesPropertyValue(this.testSuiteName, false);
        ArrayList<String> testClassNamesExcludesRelativeGlobs = new ArrayList<String>();
        if (testClassNamesExcludesPropertyValue != null && !testClassNamesExcludesPropertyValue.isEmpty()) {
            Collections.addAll(testClassNamesExcludesRelativeGlobs, JenkinsResultsParserUtil.getGlobsFromProperty(testClassNamesExcludesPropertyValue));
        }
        if (this.testRelevantChanges) {
            testClassNamesExcludesRelativeGlobs.addAll(this.getRelevantTestClassNamesRelativeExcludesGlobs());
        }
        if (this.includeStableTestSuite && this.isStableTestSuiteBatch() && (stableTestClassNamesExcludesPropertyValue = this._getTestClassNamesExcludesPropertyValue("stable", false)) != null && !stableTestClassNamesExcludesPropertyValue.isEmpty()) {
            Collections.addAll(testClassNamesExcludesRelativeGlobs, JenkinsResultsParserUtil.getGlobsFromProperty(stableTestClassNamesExcludesPropertyValue));
        }
        this.testClassNamesExcludesPathMatchers.addAll(JenkinsResultsParserUtil.toPathMatchers(JenkinsResultsParserUtil.combine(JenkinsResultsParserUtil.getCanonicalPath(this._rootWorkingDirectory), File.separator), testClassNamesExcludesRelativeGlobs.toArray(new String[0])));
    }

    private String _getRelativePath(File file, File parentFile) {
        String parentFilePath;
        String filePath = JenkinsResultsParserUtil.getCanonicalPath(file);
        if (!filePath.startsWith(parentFilePath = JenkinsResultsParserUtil.getCanonicalPath(parentFile))) {
            throw new IllegalArgumentException("Working directory does not contain this file");
        }
        return filePath.replaceAll(parentFilePath, "");
    }

    private String _getTestClassNamesExcludesPropertyValue(String testSuiteName, boolean useRequiredVariant) {
        String propertyName = "test.batch.class.names.excludes";
        if (useRequiredVariant) {
            propertyName = propertyName + ".required";
        }
        ArrayList<String> propertyValues = new ArrayList<String>();
        String propertyValue = this.getFirstPropertyValue(propertyName, this.batchName, testSuiteName);
        if (propertyValue != null) {
            propertyValues.add(propertyValue);
        } else {
            propertyValues.add(JenkinsResultsParserUtil.getProperty(this.jobProperties, propertyName));
        }
        if (!this.testPrivatePortalBranch) {
            propertyValues.add(_GLOB_MODULES_PRIVATE);
        }
        return JenkinsResultsParserUtil.join(",", propertyValues);
    }

    private String _getTestClassNamesIncludesPropertyValue(String testSuiteName, boolean useRequiredVariant) {
        String propertyName = "test.batch.class.names.includes";
        if (useRequiredVariant) {
            propertyName = propertyName + ".required";
        }
        ArrayList<String> propertyValues = new ArrayList<String>();
        String propertyValue = JenkinsResultsParserUtil.getProperty(this.getJobProperties(), propertyName, testSuiteName, this.batchName, this.getJobName());
        if (propertyValue != null) {
            propertyValues.add(propertyValue);
        } else {
            propertyValues.add(JenkinsResultsParserUtil.getProperty(this.jobProperties, propertyName));
        }
        return JenkinsResultsParserUtil.join(",", propertyValues);
    }

    private void _setAutoBalanceTestFiles() {
        String propertyName = "test.class.names.auto.balance";
        String autoBalanceTestNames = this.getFirstPropertyValue(propertyName);
        if (autoBalanceTestNames != null && !autoBalanceTestNames.equals("")) {
            for (String autoBalanceTestName : autoBalanceTestNames.split(",")) {
                this._autoBalanceTestFiles.add(new File(autoBalanceTestName));
            }
        }
    }

    private void _setIncludeAutoBalanceTests() {
        if (!this.testClasses.isEmpty()) {
            this._includeAutoBalanceTests = true;
            return;
        }
        List<File> modifiedJavaFilesList = this.portalGitWorkingDirectory.getModifiedFilesList(this._includeUnstagedTestClassFiles, null, JenkinsResultsParserUtil.toPathMatchers(JenkinsResultsParserUtil.combine("**", File.separator, "*.java"), new String[0]));
        if (!this._autoBalanceTestFiles.isEmpty() && !modifiedJavaFilesList.isEmpty()) {
            this._includeAutoBalanceTests = true;
            return;
        }
        this._includeAutoBalanceTests = false;
    }

    private void _setTestClassNamesIncludesRelativeGlobs() {
        String testClassNamesIncludesPropertyValue = this._getTestClassNamesIncludesPropertyValue(this.testSuiteName, false);
        if (testClassNamesIncludesPropertyValue == null || testClassNamesIncludesPropertyValue.isEmpty()) {
            return;
        }
        List<String> testClassNamesIncludesRelativeGlobs = new ArrayList<String>();
        Collections.addAll(testClassNamesIncludesRelativeGlobs, JenkinsResultsParserUtil.getGlobsFromProperty(testClassNamesIncludesPropertyValue));
        if (this.testReleaseBundle) {
            testClassNamesIncludesRelativeGlobs = this.getReleaseTestClassNamesRelativeIncludesGlobs(testClassNamesIncludesRelativeGlobs);
        } else if (this.testRelevantChanges) {
            testClassNamesIncludesRelativeGlobs = this.getRelevantTestClassNamesRelativeIncludesGlobs(testClassNamesIncludesRelativeGlobs);
        }
        String testBatchClassNamesIncludesRequiredPropertyValue = this._getTestClassNamesIncludesPropertyValue(this.testSuiteName, true);
        if (testBatchClassNamesIncludesRequiredPropertyValue != null && !testBatchClassNamesIncludesRequiredPropertyValue.isEmpty()) {
            Collections.addAll(testClassNamesIncludesRelativeGlobs, JenkinsResultsParserUtil.getGlobsFromProperty(testBatchClassNamesIncludesRequiredPropertyValue));
        }
        if (this.includeStableTestSuite && this.isStableTestSuiteBatch()) {
            Collections.addAll(testClassNamesIncludesRelativeGlobs, JenkinsResultsParserUtil.getGlobsFromProperty(this._getTestClassNamesIncludesPropertyValue("stable", false)));
            testBatchClassNamesIncludesRequiredPropertyValue = this._getTestClassNamesIncludesPropertyValue("stable", true);
            if (testBatchClassNamesIncludesRequiredPropertyValue != null && !testBatchClassNamesIncludesRequiredPropertyValue.isEmpty()) {
                Collections.addAll(testClassNamesIncludesRelativeGlobs, JenkinsResultsParserUtil.getGlobsFromProperty(testBatchClassNamesIncludesRequiredPropertyValue));
            }
        }
        this.testClassNamesIncludesPathMatchers.addAll(JenkinsResultsParserUtil.toPathMatchers(JenkinsResultsParserUtil.combine(JenkinsResultsParserUtil.getCanonicalPath(this._rootWorkingDirectory), File.separator), testClassNamesIncludesRelativeGlobs.toArray(new String[0])));
    }

    public static class JunitBatchTestClass
    extends BaseTestClassGroup.BaseTestClass {
        private static Pattern _classHeaderPattern = Pattern.compile(JenkinsResultsParserUtil.combine("\\*/(?<annotations>[^/]*)public\\s+class\\s+", "(?<className>[^\\(\\s]+)"));
        private static final Map<File, JunitBatchTestClass> _junitTestClasses = new HashMap<File, JunitBatchTestClass>();
        private static Pattern _methodHeaderPattern = Pattern.compile(JenkinsResultsParserUtil.combine("\\t(?<annotations>(@[\\s\\S]+?))public\\s+void\\s+", "(?<methodName>[^\\(\\s]+)"));
        private boolean _classIgnored;
        private final String _className;
        private final GitWorkingDirectory _gitWorkingDirectory;
        private final String _packageName;
        private final File _srcFile;
        private final String _srcFileContent;

        public File getWorkingDirectory() {
            return this._gitWorkingDirectory.getWorkingDirectory();
        }

        @Override
        public boolean isIgnored() {
            return this._classIgnored;
        }

        protected static JunitBatchTestClass getInstance(File testClassFile, GitWorkingDirectory gitWorkingDirectory, File javaFile) {
            if (_junitTestClasses.containsKey(testClassFile)) {
                return _junitTestClasses.get(testClassFile);
            }
            JunitBatchTestClass junitTestClass = new JunitBatchTestClass(testClassFile, gitWorkingDirectory, javaFile);
            _junitTestClasses.put(testClassFile, junitTestClass);
            return junitTestClass;
        }

        protected static JunitBatchTestClass getInstance(String fullClassName, GitWorkingDirectory gitWorkingDirectory) {
            File javaFile = gitWorkingDirectory.getJavaFileFromFullClassName(fullClassName);
            if (javaFile == null) {
                System.out.println("No matching files found for " + fullClassName);
                return null;
            }
            String packagePath = fullClassName.replace('.', '/');
            File testClassFile = new File(packagePath = packagePath + ".class");
            if (_junitTestClasses.containsKey(testClassFile)) {
                return _junitTestClasses.get(testClassFile);
            }
            return JunitBatchTestClass.getInstance(testClassFile, gitWorkingDirectory, javaFile);
        }

        protected static Map<File, JunitBatchTestClass> getJunitTestClasses() {
            return _junitTestClasses;
        }

        protected JunitBatchTestClass(File testClassFile, GitWorkingDirectory gitWorkingDirectory, File srcFile) {
            super(testClassFile);
            String srcFileName = srcFile.getName();
            this._gitWorkingDirectory = gitWorkingDirectory;
            this._srcFile = srcFile;
            this._className = this._getClassName();
            this._packageName = this._getPackageName();
            if (!srcFileName.endsWith(".java")) {
                this._srcFileContent = "";
                return;
            }
            try {
                this._srcFileContent = JenkinsResultsParserUtil.read(this._srcFile);
                this._initTestClassMethods();
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }

        private String _getClassName() {
            String srcFileName = this._srcFile.getName();
            return srcFileName.substring(0, srcFileName.lastIndexOf("."));
        }

        private String _getPackageName() {
            String srcFilePath = this._srcFile.toString();
            int x = srcFilePath.indexOf("/com/");
            int y = srcFilePath.lastIndexOf("/");
            srcFilePath = srcFilePath.substring(x + 1, y);
            return srcFilePath.replaceAll("/", ".");
        }

        private String _getParentClassName() {
            Pattern classHeaderPattern = Pattern.compile(JenkinsResultsParserUtil.combine("public\\s+(abstract\\s+)?(class|interface)\\s+", this._className, "(\\<[^\\<]+\\>)?(?<classHeaderEntities>[^\\{]+)\\{"));
            Matcher classHeaderMatcher = classHeaderPattern.matcher(this._srcFileContent);
            if (!classHeaderMatcher.find()) {
                throw new RuntimeException("No class header found in " + this._srcFile);
            }
            String classHeaderEntities = classHeaderMatcher.group("classHeaderEntities");
            Pattern parentClassPattern = Pattern.compile(JenkinsResultsParserUtil.combine("extends\\s+(?<parentClassName>[^\\s\\<]+)"));
            Matcher parentClassMatcher = parentClassPattern.matcher(classHeaderEntities);
            if (parentClassMatcher.find()) {
                return parentClassMatcher.group("parentClassName");
            }
            return null;
        }

        private String _getParentFullClassName() {
            String parentClassName = this._getParentClassName();
            if (parentClassName == null) {
                return null;
            }
            if (parentClassName.contains(".") && parentClassName.matches("[a-z].*")) {
                if (!parentClassName.startsWith("com.liferay")) {
                    return null;
                }
                return parentClassName;
            }
            String parentPackageName = this._getParentPackageName(parentClassName);
            if (parentPackageName == null) {
                return null;
            }
            return parentPackageName + "." + parentClassName;
        }

        private String _getParentPackageName(String parentClassName) {
            Pattern parentImportClassPattern = Pattern.compile(JenkinsResultsParserUtil.combine("import\\s+(?<parentPackageName>[^;]+)\\.", parentClassName, ";"));
            Matcher parentImportClassMatcher = parentImportClassPattern.matcher(this._srcFileContent);
            if (parentImportClassMatcher.find()) {
                String parentPackageName = parentImportClassMatcher.group("parentPackageName");
                if (!parentPackageName.startsWith("com.liferay")) {
                    return null;
                }
                return parentPackageName;
            }
            return this._packageName;
        }

        private void _initTestClassMethods() throws IOException {
            String annotations;
            Matcher classHeaderMatcher = _classHeaderPattern.matcher(this._srcFileContent);
            this._classIgnored = false;
            if (classHeaderMatcher.find() && (annotations = classHeaderMatcher.group("annotations")) != null && annotations.contains("@Ignore")) {
                this._classIgnored = true;
            }
            Matcher methodHeaderMatcher = _methodHeaderPattern.matcher(this._srcFileContent);
            while (methodHeaderMatcher.find()) {
                String annotations2 = methodHeaderMatcher.group("annotations");
                boolean methodIgnored = false;
                if (this._classIgnored || annotations2.contains("@Ignore")) {
                    methodIgnored = true;
                }
                if (!annotations2.contains("@Test")) continue;
                String methodName = methodHeaderMatcher.group("methodName");
                this.addTestClassMethod(methodIgnored, methodName);
            }
            String parentFullClassName = this._getParentFullClassName();
            if (parentFullClassName == null) {
                return;
            }
            JunitBatchTestClass parentJunitBatchTestClass = JunitBatchTestClass.getInstance(parentFullClassName, this._gitWorkingDirectory);
            if (parentJunitBatchTestClass == null) {
                return;
            }
            for (TestClassGroup.TestClass.TestClassMethod testClassMethod : parentJunitBatchTestClass.getTestClassMethods()) {
                if (this._classIgnored) {
                    this.addTestClassMethod(this._classIgnored, testClassMethod.getName());
                    continue;
                }
                this.addTestClassMethod(testClassMethod);
            }
        }
    }
}

