/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.group.ModulesBatchTestClassGroup;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import org.json.JSONException;
import org.json.JSONObject;

public class JSUnitModulesBatchTestClassGroup
extends ModulesBatchTestClassGroup {
    protected JSUnitModulesBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
    }

    @Override
    protected void setTestClasses() throws IOException {
        ArrayList<File> moduleDirs = new ArrayList<File>();
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        if (this.testRelevantChanges) {
            moduleDirs.addAll(portalGitWorkingDirectory.getModifiedModuleDirsList(this.excludesPathMatchers, this.includesPathMatchers));
        } else {
            moduleDirs.addAll(portalGitWorkingDirectory.getModuleDirsList(this.excludesPathMatchers, this.includesPathMatchers));
        }
        final ArrayList projectDirs = new ArrayList();
        final File modulesDir = new File(portalGitWorkingDirectory.getWorkingDirectory(), "modules");
        final boolean testGitrepoJSUnit = this._testGitrepoJSUnit();
        for (File moduleDir : moduleDirs) {
            Path moduleDirPath = moduleDir.toPath();
            Files.walkFileTree(moduleDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path filePath, BasicFileAttributes basicFileAttributes) {
                    File gitrepoFile;
                    if (filePath.equals(modulesDir.toPath())) {
                        return FileVisitResult.CONTINUE;
                    }
                    File file = filePath.toFile();
                    File currentDirectory = new File(JenkinsResultsParserUtil.getCanonicalPath(file));
                    if (!testGitrepoJSUnit && (gitrepoFile = new File(currentDirectory, ".gitrepo")).exists()) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    File buildGradleFile = new File(currentDirectory, "build.gradle");
                    File packageJSONFile = new File(currentDirectory, "package.json");
                    if (!buildGradleFile.exists() || !packageJSONFile.exists()) {
                        return FileVisitResult.CONTINUE;
                    }
                    try {
                        JSONObject packageJSONObject = new JSONObject(JenkinsResultsParserUtil.read(packageJSONFile));
                        if (!packageJSONObject.has("scripts")) {
                            return FileVisitResult.CONTINUE;
                        }
                        JSONObject scriptsJSONObject = packageJSONObject.getJSONObject("scripts");
                        if (!scriptsJSONObject.has("test")) {
                            return FileVisitResult.CONTINUE;
                        }
                        projectDirs.add(currentDirectory);
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    catch (IOException | JSONException exception) {
                        return FileVisitResult.CONTINUE;
                    }
                }
            });
        }
        for (File projectDir : projectDirs) {
            this.testClasses.add(new JSUnitModulesBatchTestClass(projectDir, modulesDir));
        }
        Collections.sort(this.testClasses);
    }

    private boolean _testGitrepoJSUnit() {
        String testGitrepoJSUnit = JenkinsResultsParserUtil.getProperty(this.portalTestClassJob.getJobProperties(), "test.gitrepo.js.unit", this.portalTestClassJob.getJobName(), this.getTestSuiteName());
        return !JenkinsResultsParserUtil.isNullOrEmpty(testGitrepoJSUnit) && testGitrepoJSUnit.equals("true");
    }

    public static class JSUnitModulesBatchTestClass
    extends ModulesBatchTestClassGroup.ModulesBatchTestClass {
        protected JSUnitModulesBatchTestClass(File projectDir, File modulesDir) {
            super(projectDir);
            String path = JenkinsResultsParserUtil.getPathRelativeTo(projectDir, modulesDir);
            String moduleTaskCall = JenkinsResultsParserUtil.combine(":", path.replaceAll("/", ":"), ":packageRunTest");
            this.addTestClassMethod(moduleTaskCall);
        }
    }
}

