/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalAxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.SegmentTestClassGroup;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class FunctionalSegmentTestClassGroup
extends SegmentTestClassGroup {
    private final BatchTestClassGroup _parentBatchTestClassGroup;

    public FunctionalAxisTestClassGroup getFunctionalAxisTestClassGroup(int segmentIndex) {
        List<FunctionalAxisTestClassGroup> functionalAxisTestClassGroups = this.getFunctionalAxisTestClassGroups();
        return functionalAxisTestClassGroups.get(segmentIndex);
    }

    public List<FunctionalAxisTestClassGroup> getFunctionalAxisTestClassGroups() {
        ArrayList<FunctionalAxisTestClassGroup> functionalAxisTestClassGroups = new ArrayList<FunctionalAxisTestClassGroup>();
        for (AxisTestClassGroup axisTestClassGroup : this.getAxisTestClassGroups()) {
            if (!(axisTestClassGroup instanceof FunctionalAxisTestClassGroup)) continue;
            FunctionalAxisTestClassGroup functionalAxisTestClassGroup = (FunctionalAxisTestClassGroup)axisTestClassGroup;
            functionalAxisTestClassGroups.add(functionalAxisTestClassGroup);
        }
        return functionalAxisTestClassGroups;
    }

    @Override
    public Integer getMinimumSlaveRAM() {
        Properties poshiProperties = this.getPoshiProperties();
        String minimumSlaveRAM = poshiProperties.getProperty("minimum.slave.ram");
        if (minimumSlaveRAM != null && minimumSlaveRAM.matches("\\d+")) {
            return Integer.valueOf(minimumSlaveRAM);
        }
        return super.getMinimumSlaveRAM();
    }

    public Properties getPoshiProperties() {
        List<FunctionalAxisTestClassGroup> functionalAxisTestClassGroups = this.getFunctionalAxisTestClassGroups();
        FunctionalAxisTestClassGroup functionalAxisTestClassGroup = functionalAxisTestClassGroups.get(0);
        return functionalAxisTestClassGroup.getPoshiProperties();
    }

    @Override
    public String getSlaveLabel() {
        Properties poshiProperties = this.getPoshiProperties();
        String slaveLabel = poshiProperties.getProperty("slave.label");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(slaveLabel)) {
            return slaveLabel;
        }
        return super.getSlaveLabel();
    }

    @Override
    public String getTestCasePropertiesContent() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getTestCasePropertiesContent());
        ArrayList<String> axisGroupNames = new ArrayList<String>();
        int batchIndex = this.getBatchIndex();
        for (int axisIndex = 0; axisIndex < this.getAxisCount(); ++axisIndex) {
            axisGroupNames.add(batchIndex + "_" + axisIndex);
            sb.append("RUN_TEST_CASE_METHOD_GROUP_");
            sb.append(batchIndex);
            sb.append("_");
            sb.append(axisIndex);
            sb.append("=");
            FunctionalAxisTestClassGroup functionalAxisTestClassGroup = this.getFunctionalAxisTestClassGroup(axisIndex);
            sb.append(JenkinsResultsParserUtil.join(",", functionalAxisTestClassGroup.getTestClassMethodNames()));
            sb.append("\n");
        }
        sb.append("RUN_TEST_CASE_METHOD_GROUP_");
        sb.append(batchIndex);
        sb.append("=");
        sb.append(JenkinsResultsParserUtil.join(" ", axisGroupNames));
        sb.append("\n");
        return sb.toString();
    }

    protected FunctionalSegmentTestClassGroup(BatchTestClassGroup parentBatchTestClassGroup) {
        super(parentBatchTestClassGroup);
        this._parentBatchTestClassGroup = parentBatchTestClassGroup;
    }

    protected Map.Entry<String, String> getEnvironmentVariableEntry(String key, String name) {
        if (JenkinsResultsParserUtil.isNullOrEmpty(key) || JenkinsResultsParserUtil.isNullOrEmpty(name)) {
            return null;
        }
        String value = JenkinsResultsParserUtil.getProperty(this._parentBatchTestClassGroup.getJobProperties(), name, this._parentBatchTestClassGroup.getBatchName());
        if (JenkinsResultsParserUtil.isNullOrEmpty(value)) {
            return null;
        }
        return new AbstractMap.SimpleEntry<String, String>(key, value);
    }
}

