/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.RootCauseAnalysisToolJob;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.RCABatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FunctionalRCABatchTestClassGroup
extends RCABatchTestClassGroup {
    private static final Pattern _pattern = Pattern.compile("((<?namespace>[^\\.]+)\\.)?(?<classMethodName>[^#]+#.+)");

    protected FunctionalRCABatchTestClassGroup(String batchName, RootCauseAnalysisToolJob rootCauseAnalysisToolJob) {
        super(batchName, rootCauseAnalysisToolJob);
        this.setAxisTestClassGroups();
        this.setSegmentTestClassGroups();
    }

    @Override
    protected void setAxisTestClassGroups() {
        if (!this.axisTestClassGroups.isEmpty()) {
            return;
        }
        String portalBatchTestSelector = System.getenv("PORTAL_BATCH_TEST_SELECTOR");
        if (JenkinsResultsParserUtil.isNullOrEmpty(portalBatchTestSelector)) {
            return;
        }
        Matcher matcher = _pattern.matcher(portalBatchTestSelector);
        if (!matcher.find()) {
            return;
        }
        String namespace = matcher.group("namespace");
        if (JenkinsResultsParserUtil.isNullOrEmpty(namespace)) {
            namespace = "LocalFile";
        }
        String classMethodName = matcher.group("classMethodName");
        AxisTestClassGroup axisTestClassGroup = TestClassGroupFactory.newAxisTestClassGroup(this, this._getTestBaseDir());
        axisTestClassGroup.addTestClass(FunctionalBatchTestClassGroup.FunctionalTestClass.getInstance(JenkinsResultsParserUtil.combine(namespace, ".", classMethodName)));
        this.axisTestClassGroups.add(axisTestClassGroup);
    }

    private File _getTestBaseDir() {
        return new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "portal-web/test/functional/portalweb");
    }
}

