/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.google.common.collect.Lists;
import com.liferay.jenkins.results.parser.AntException;
import com.liferay.jenkins.results.parser.AntUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BaseTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.util.PropsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FunctionalBatchTestClassGroup
extends BatchTestClassGroup {
    private static final Pattern _poshiTestCasePattern = Pattern.compile("(?<namespace>[^\\.]+)\\.(?<className>[^\\#]+)\\#(?<methodName>.*)");
    private final Map<File, String> _testBatchRunPropertyQueries = new HashMap<File, String>();

    @Override
    public int getAxisCount() {
        return this.axisTestClassGroups.size();
    }

    public List<File> getTestBaseDirs() {
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        return Arrays.asList(new File(portalGitWorkingDirectory.getWorkingDirectory(), "portal-web/test/functional/portalweb"));
    }

    public String getTestBatchRunPropertyQuery() {
        List<File> testBaseDirs = this.getTestBaseDirs();
        if (testBaseDirs.isEmpty()) {
            return null;
        }
        return this.getTestBatchRunPropertyQuery(testBaseDirs.get(0));
    }

    public String getTestBatchRunPropertyQuery(File testBaseDir) {
        return this._testBatchRunPropertyQueries.get(testBaseDir);
    }

    @Override
    public List<TestClassGroup.TestClass> getTestClasses() {
        ArrayList<TestClassGroup.TestClass> testClasses = new ArrayList<TestClassGroup.TestClass>();
        for (AxisTestClassGroup axisTestClassGroup : this.axisTestClassGroups) {
            testClasses.addAll(axisTestClassGroup.getTestClasses());
        }
        return testClasses;
    }

    protected FunctionalBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
        this._setTestBatchRunPropertyQueries();
        this.setAxisTestClassGroups();
        this.setSegmentTestClassGroups();
    }

    protected String getDefaultTestBatchRunPropertyQuery(File testBaseDir, String testSuiteName) {
        String propertyQuery = System.getenv("TEST_BATCH_RUN_PROPERTY_QUERY");
        if (propertyQuery != null && !propertyQuery.isEmpty()) {
            return propertyQuery;
        }
        return JenkinsResultsParserUtil.getProperty(this.jobProperties, "test.batch.run.property.query", testSuiteName, this.batchName, this.getJobName());
    }

    protected List<List<String>> getPoshiTestClassGroups(File testBaseDir) {
        String query = this.getTestBatchRunPropertyQuery(testBaseDir);
        if (JenkinsResultsParserUtil.isNullOrEmpty(query)) {
            return new ArrayList<List<String>>();
        }
        PortalTestClassJob portalTestClassJob = this.portalTestClassJob;
        synchronized (portalTestClassJob) {
            PortalGitWorkingDirectory portalGitWorkingDirectory = this.portalTestClassJob.getPortalGitWorkingDirectory();
            File portalWorkingDirectory = portalGitWorkingDirectory.getWorkingDirectory();
            HashMap<String, String> parameters = new HashMap<String, String>();
            String testBaseDirPath = null;
            if (testBaseDir != null && testBaseDir.exists()) {
                testBaseDirPath = JenkinsResultsParserUtil.getCanonicalPath(testBaseDir);
                parameters.put("test.base.dir.name", testBaseDirPath);
            }
            try {
                AntUtil.callTarget(portalWorkingDirectory, "build-test.xml", "prepare-poshi-runner-properties", parameters);
            }
            catch (AntException antException) {
                throw new RuntimeException(antException);
            }
            Properties properties = JenkinsResultsParserUtil.getProperties(new File(portalWorkingDirectory, "portal-web/test/test-portal-web.properties"), new File(portalWorkingDirectory, "portal-web/test/test-portal-web-ext.properties"));
            properties.setProperty("ignore.errors.util.classes", "true");
            if (!JenkinsResultsParserUtil.isNullOrEmpty(testBaseDirPath)) {
                properties.setProperty("test.base.dir.name", testBaseDirPath);
            }
            PropsUtil.clear();
            PropsUtil.setProperties((Properties)properties);
            try {
                PoshiContext.clear();
                PoshiContext.readFiles();
                return PoshiContext.getTestBatchGroups((String)query, (int)this.getAxisMaxSize());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    @Override
    protected void setAxisTestClassGroups() {
        if (!this.axisTestClassGroups.isEmpty()) {
            return;
        }
        for (File testBaseDir : this.getTestBaseDirs()) {
            String query = this.getTestBatchRunPropertyQuery(testBaseDir);
            if (query == null) continue;
            List<List<String>> poshiTestClassGroups = this.getPoshiTestClassGroups(testBaseDir);
            for (List<String> poshiTestClassGroup : poshiTestClassGroups) {
                if (poshiTestClassGroup.isEmpty()) continue;
                AxisTestClassGroup axisTestClassGroup = TestClassGroupFactory.newAxisTestClassGroup(this, testBaseDir);
                for (String testClassMethodName : poshiTestClassGroup) {
                    Matcher matcher = _poshiTestCasePattern.matcher(testClassMethodName);
                    if (!matcher.find()) {
                        throw new RuntimeException("Invalid test class method name " + testClassMethodName);
                    }
                    axisTestClassGroup.addTestClass(FunctionalTestClass.getInstance(testClassMethodName));
                }
                this.axisTestClassGroups.add(axisTestClassGroup);
            }
        }
    }

    private String _getDefaultTestBatchRunPropertyGlobalQuery(String testSuiteName) {
        return JenkinsResultsParserUtil.getProperty(this.jobProperties, "test.batch.run.property.global.query", testSuiteName, this.batchName, this.getJobName());
    }

    private List<File> _getFunctionalRequiredModuleDirs(List<File> moduleDirs) {
        ArrayList functionalRequiredModuleDirs = Lists.newArrayList(moduleDirs);
        File modulesBaseDir = new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "modules");
        for (File moduleDir : moduleDirs) {
            Properties moduleDirTestProperties = JenkinsResultsParserUtil.getProperties(new File(moduleDir, "test.properties"));
            String functionalRequiredModuleDirPaths = moduleDirTestProperties.getProperty("modules.includes.required.functional[" + this.testSuiteName + "]");
            if (functionalRequiredModuleDirPaths == null) continue;
            for (String functionalRequiredModuleDirPath : functionalRequiredModuleDirPaths.split(",")) {
                File functionalRequiredModuleDir = new File(modulesBaseDir, functionalRequiredModuleDirPath);
                if (!functionalRequiredModuleDir.exists() || functionalRequiredModuleDirs.contains(functionalRequiredModuleDir)) continue;
                functionalRequiredModuleDirs.add(functionalRequiredModuleDir);
            }
        }
        return Lists.newArrayList((Iterable)functionalRequiredModuleDirs);
    }

    private String _getTestBatchRunPropertyQuery(File testBaseDir) {
        String stableTestBatchRunPropertyQuery;
        if (!this.testRelevantChanges) {
            return this.getDefaultTestBatchRunPropertyQuery(testBaseDir, this.testSuiteName);
        }
        HashSet<File> modifiedDirsList = new HashSet<File>();
        try {
            modifiedDirsList.addAll(this.portalGitWorkingDirectory.getModifiedModuleDirsList());
        }
        catch (IOException ioException) {
            File workingDirectory = this.portalGitWorkingDirectory.getWorkingDirectory();
            throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to get module directories in ", workingDirectory.getPath()), ioException);
        }
        File modulesDir = new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "modules");
        modifiedDirsList.addAll(this.portalGitWorkingDirectory.getModifiedDirsList(false, JenkinsResultsParserUtil.toPathMatchers(null, JenkinsResultsParserUtil.getCanonicalPath(modulesDir)), null));
        modifiedDirsList.addAll(this.getRequiredModuleDirs(Lists.newArrayList(modifiedDirsList)));
        modifiedDirsList.addAll(this._getFunctionalRequiredModuleDirs(Lists.newArrayList(modifiedDirsList)));
        StringBuilder sb = new StringBuilder();
        for (File modifiedDir : modifiedDirsList) {
            File modifiedDirTestProperties = new File(modifiedDir, "test.properties");
            if (!modifiedDirTestProperties.exists()) continue;
            Properties testProperties = JenkinsResultsParserUtil.getProperties(modifiedDirTestProperties);
            String testBatchRunPropertyQuery = null;
            String firstMatchingPropertyName = this.getFirstMatchingPropertyName("test.batch.run.property.query", testProperties, this.testSuiteName);
            if (firstMatchingPropertyName != null) {
                testBatchRunPropertyQuery = JenkinsResultsParserUtil.getProperty(testProperties, firstMatchingPropertyName);
            }
            if (testBatchRunPropertyQuery == null) {
                testBatchRunPropertyQuery = JenkinsResultsParserUtil.getProperty(testProperties, JenkinsResultsParserUtil.combine("test.batch.run.property.query[", this.batchName, "][", this.testSuiteName, "]"));
            }
            if (testBatchRunPropertyQuery == null) continue;
            if (sb.length() > 0) {
                sb.append(" OR (");
            } else {
                sb.append("(");
            }
            sb.append(testBatchRunPropertyQuery);
            sb.append(")");
        }
        if (sb.length() == 0) {
            sb.append("(");
            sb.append(this.getDefaultTestBatchRunPropertyQuery(testBaseDir, this.testSuiteName));
            sb.append(")");
        }
        if ((stableTestBatchRunPropertyQuery = this.getDefaultTestBatchRunPropertyQuery(testBaseDir, "stable")) != null && this.includeStableTestSuite && this.isStableTestSuiteBatch()) {
            sb.append(" OR (");
            sb.append(stableTestBatchRunPropertyQuery);
            sb.append(")");
        }
        String testBatchRunPropertyQuery = sb.toString();
        String defaultGlobalQuery = this._getDefaultTestBatchRunPropertyGlobalQuery(this.testSuiteName);
        if (defaultGlobalQuery != null && !defaultGlobalQuery.isEmpty()) {
            testBatchRunPropertyQuery = JenkinsResultsParserUtil.combine("(", defaultGlobalQuery, ") AND (", testBatchRunPropertyQuery, ")");
        }
        return testBatchRunPropertyQuery;
    }

    private void _setTestBatchRunPropertyQueries() {
        for (File testBaseDir : this.getTestBaseDirs()) {
            String testBatchRunPropertyQuery = this._getTestBatchRunPropertyQuery(testBaseDir);
            if (JenkinsResultsParserUtil.isNullOrEmpty(testBatchRunPropertyQuery)) continue;
            this._testBatchRunPropertyQueries.put(testBaseDir, testBatchRunPropertyQuery);
        }
    }

    public static class FunctionalTestClass
    extends BaseTestClassGroup.BaseTestClass {
        private final Properties _poshiProperties;
        private final String _testClassMethodName;

        public Properties getPoshiProperties() {
            return this._poshiProperties;
        }

        public String getTestClassMethodName() {
            return this._testClassMethodName;
        }

        protected static FunctionalTestClass getInstance(String testClassMethodName) {
            return new FunctionalTestClass(testClassMethodName);
        }

        protected FunctionalTestClass(String testClassMethodName) {
            super(FunctionalTestClass._getTestClassFile(testClassMethodName));
            this.addTestClassMethod(testClassMethodName);
            this._testClassMethodName = testClassMethodName;
            this._poshiProperties = PoshiContext.getNamespacedClassCommandNameProperties((String)this.getTestClassMethodName());
        }

        private static File _getTestClassFile(String testClassMethodName) {
            Matcher matcher = _poshiTestCasePattern.matcher(testClassMethodName);
            if (!matcher.find()) {
                throw new RuntimeException("Invalid test class method name " + testClassMethodName);
            }
            String className = matcher.group("className");
            String namespace = matcher.group("namespace");
            File testClassFile = null;
            try {
                testClassFile = new File(PoshiContext.getFilePathFromFileName((String)(className + ".testcase"), (String)namespace));
            }
            catch (Exception exception) {
                testClassFile = new File(PoshiContext.getFilePathFromFileName((String)(className + ".prose"), (String)namespace));
            }
            return testClassFile;
        }
    }
}

