/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.group.BaseTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class CucumberBatchTestClassGroup
extends BatchTestClassGroup {
    private static final Pattern _featureFilePattern = Pattern.compile("(?<featureTags>[\\S\\s]+)(?<featureName>Feature\\: [^\\n]*)\\n\\t*(?<featureDescription>[^\\n]*)\\n(?<featureBody>[\\S\\s]+)");
    private static final Pattern _featureTagPattern = Pattern.compile("@[^\\s]+");
    private static final Pattern _scenarioPattern = Pattern.compile("\\s*(?<scenarioName>Scenario: [^\\n]+)\\n");
    private static final Pattern _tagExpressionPattern = Pattern.compile("--tags (?<tagExpression>[^ ]+)");

    public File getFaroDir() {
        File faroDir = new File(JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "analytics.cloud.faro.dir"));
        try {
            return new File(faroDir.getCanonicalPath());
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected CucumberBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
        this._setTestClasses();
        this.setAxisTestClassGroups();
        this.setSegmentTestClassGroups();
    }

    private String _getCucumberOptions() {
        String cucumberOptions = System.getenv("CUCUMBER_OPTIONS");
        if (cucumberOptions == null) {
            cucumberOptions = JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.cucumber.options", this.getTestSuiteName(), this.getBatchName());
        }
        if (cucumberOptions == null) {
            cucumberOptions = JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "analytics.cloud.cucumber.options");
        }
        return cucumberOptions;
    }

    private File _getFeatureBaseDir() {
        String cucumberOptions = this._getCucumberOptions();
        return new File(this.getFaroDir(), JenkinsResultsParserUtil.combine("osb-faro-functional-test/", cucumberOptions.replaceAll(".* ([^ ]+)", "$1")));
    }

    private List<String> _getTagExpressions() {
        Matcher matcher = _tagExpressionPattern.matcher(this._getCucumberOptions());
        ArrayList<String> tagExpressions = new ArrayList<String>();
        while (matcher.find()) {
            tagExpressions.add(matcher.group("tagExpression"));
        }
        return tagExpressions;
    }

    private void _setTestClasses() {
        List<File> featureFiles = JenkinsResultsParserUtil.findFiles(this._getFeatureBaseDir(), ".*\\.feature");
        for (File featureFile : featureFiles) {
            String featureContent;
            try {
                featureContent = JenkinsResultsParserUtil.read(featureFile);
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            Matcher featureFileMatcher = _featureFilePattern.matcher(featureContent);
            if (!featureFileMatcher.find()) {
                throw new RuntimeException("Invalid feature file " + featureFile);
            }
            Matcher featureTagMatcher = _featureTagPattern.matcher(featureFileMatcher.group("featureTags"));
            ArrayList<String> featureTags = new ArrayList<String>();
            while (featureTagMatcher.find()) {
                featureTags.add(featureTagMatcher.group());
            }
            Matcher scenarioMatcher = _scenarioPattern.matcher(featureFileMatcher.group("featureBody"));
            while (scenarioMatcher.find()) {
                CucumberTestClass cucumberTestClass = new CucumberTestClass(this, featureFile, featureFileMatcher.group("featureName"), featureFileMatcher.group("featureDescription"), featureTags, scenarioMatcher.group("scenarioName"));
                if (!cucumberTestClass.matchesTagExpressions(this._getTagExpressions())) continue;
                this.testClasses.add(cucumberTestClass);
            }
        }
        Collections.sort(this.testClasses);
    }

    public static class CucumberTestClass
    extends BaseTestClassGroup.BaseTestClass {
        private final CucumberBatchTestClassGroup _cucumberBatchTestClassGroup;
        private final String _featureDescription;
        private final String _featureName;
        private final List<String> _featureTags;
        private final String _scenarioName;

        public List<String> getCategoryNames() {
            String folderNames = JenkinsResultsParserUtil.getPathRelativeTo(this.getTestClassFile(), this._cucumberBatchTestClassGroup._getFeatureBaseDir());
            folderNames = folderNames.replaceAll("(.*)/[^/]+.feature", "$1");
            folderNames = folderNames.replaceAll("\\.", " ");
            folderNames = StringUtils.capitalize((String)folderNames);
            folderNames = folderNames.replaceAll("\\s*(.+?)[/\\s]*", "$1");
            return Arrays.asList(folderNames.split("/"));
        }

        public CucumberBatchTestClassGroup getCucumberBatchTestClassGroup() {
            return this._cucumberBatchTestClassGroup;
        }

        public String getFeatureDescription() {
            return this._featureDescription;
        }

        public String getFeatureName() {
            return this._featureName;
        }

        public List<String> getFeatureTags() {
            return this._featureTags;
        }

        public String getScenarioName() {
            return this._scenarioName;
        }

        protected CucumberTestClass(CucumberBatchTestClassGroup cucumberBatchTestClassGroup, File featureFile, String featureName, String featureDescription, List<String> featureTags, String scenarioName) {
            super(featureFile);
            this.addTestClassMethod(JenkinsResultsParserUtil.combine(featureName, " > ", scenarioName));
            this._cucumberBatchTestClassGroup = cucumberBatchTestClassGroup;
            this._featureName = featureName;
            this._featureDescription = featureDescription;
            this._featureTags = featureTags;
            this._scenarioName = scenarioName;
        }

        protected boolean matchesTagExpressions(List<String> tagExpresions) {
            for (String tagExpresion : tagExpresions) {
                if (this._matchesTagExpression(tagExpresion)) continue;
                return false;
            }
            return true;
        }

        private boolean _matchesTagExpression(String tagExpression) {
            if (tagExpression.contains(",")) {
                for (String tagExpressionItem : tagExpression.split(",")) {
                    if (!this._matchesTagExpression(tagExpressionItem)) continue;
                    return true;
                }
                return false;
            }
            if (tagExpression.startsWith("~")) {
                for (String featureTag : this._featureTags) {
                    if (!featureTag.equals(tagExpression.substring(1))) continue;
                    return false;
                }
                return true;
            }
            for (String featureTag : this._featureTags) {
                if (!featureTag.equals(tagExpression)) continue;
                return true;
            }
            return false;
        }
    }
}

