/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.group.ModulesBatchTestClassGroup;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompileModulesBatchTestClassGroup
extends ModulesBatchTestClassGroup {
    @Override
    public int getAxisCount() {
        if (!this.isStableTestSuiteBatch() && this.testRelevantIntegrationUnitOnly) {
            return 0;
        }
        return super.getAxisCount();
    }

    protected CompileModulesBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
    }

    @Override
    protected void setTestClasses() throws IOException {
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        if (!(!this.testRelevantChanges || this.includeStableTestSuite && this.isStableTestSuiteBatch())) {
            List<File> modifiedModuleDirsList = portalGitWorkingDirectory.getModifiedModuleDirsList(this.excludesPathMatchers, this.includesPathMatchers);
            for (File modifiedModuleDir : modifiedModuleDirsList) {
                List<File> lfrBuildPortalFiles = JenkinsResultsParserUtil.findFiles(modifiedModuleDir, "\\.lfrbuild-portal");
                if (lfrBuildPortalFiles.isEmpty()) continue;
                this.moduleDirsList.add(modifiedModuleDir);
            }
        } else {
            this.moduleDirsList.addAll(portalGitWorkingDirectory.getModuleDirsList(this.excludesPathMatchers, this.includesPathMatchers));
        }
        File portalModulesBaseDir = new File(portalGitWorkingDirectory.getWorkingDirectory(), "modules");
        for (File moduleDir : this.moduleDirsList) {
            this.testClasses.add(CompileModulesBatchTestClass.getInstance(new File(JenkinsResultsParserUtil.getCanonicalPath(moduleDir)), portalModulesBaseDir));
        }
        Collections.sort(this.testClasses);
    }

    public static class CompileModulesBatchTestClass
    extends ModulesBatchTestClassGroup.ModulesBatchTestClass {
        protected static CompileModulesBatchTestClass getInstance(File moduleBaseDir, File modulesDir) {
            return new CompileModulesBatchTestClass(new File(JenkinsResultsParserUtil.getCanonicalPath(moduleBaseDir)), modulesDir);
        }

        protected CompileModulesBatchTestClass(File moduleBaseDir, File modulesDir) {
            super(moduleBaseDir);
            final File baseDir = modulesDir;
            final ArrayList<File> modulesProjectDirs = new ArrayList<File>();
            Path moduleBaseDirPath = moduleBaseDir.toPath();
            try {
                Files.walkFileTree(moduleBaseDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path filePath, BasicFileAttributes basicFileAttributes) {
                        if (filePath.equals(baseDir.toPath())) {
                            return FileVisitResult.CONTINUE;
                        }
                        File currentDirectory = filePath.toFile();
                        File bndBndFile = new File(currentDirectory, "bnd.bnd");
                        File buildFile = new File(currentDirectory, "build.gradle");
                        String directoryName = currentDirectory.getName();
                        if (buildFile.exists() && bndBndFile.exists()) {
                            modulesProjectDirs.add(currentDirectory);
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        if (directoryName.startsWith("frontend-theme")) {
                            File gulpFile = new File(currentDirectory, "gulpfile.js");
                            if (buildFile.exists() && gulpFile.exists()) {
                                modulesProjectDirs.add(currentDirectory);
                                return FileVisitResult.SKIP_SUBTREE;
                            }
                        }
                        buildFile = new File(currentDirectory, "build.xml");
                        if (directoryName.endsWith("-hook") && buildFile.exists()) {
                            modulesProjectDirs.add(currentDirectory);
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        if (directoryName.endsWith("-portlet")) {
                            File ivyFile = new File(currentDirectory, "ivy.xml");
                            if (buildFile.exists() && ivyFile.exists()) {
                                modulesProjectDirs.add(currentDirectory);
                                return FileVisitResult.SKIP_SUBTREE;
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException ioException) {
                throw new RuntimeException("Unable to get module marker files from " + moduleBaseDir.getPath(), ioException);
            }
            this.initTestClassMethods(modulesProjectDirs, modulesDir, "assemble");
        }
    }
}

