/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseTestClassGroup
implements TestClassGroup {
    protected final List<TestClassGroup.TestClass> testClasses = new ArrayList<TestClassGroup.TestClass>();

    @Override
    public List<TestClassGroup.TestClass> getTestClasses() {
        return this.testClasses;
    }

    @Override
    public List<File> getTestClassFiles() {
        ArrayList<File> testClassFiles = new ArrayList<File>();
        for (TestClassGroup.TestClass testClass : this.testClasses) {
            testClassFiles.add(testClass.getTestClassFile());
        }
        return testClassFiles;
    }

    protected void addTestClass(TestClassGroup.TestClass testClass) {
        this.testClasses.add(testClass);
    }

    public static abstract class BaseTestClass
    implements TestClassGroup.TestClass {
        private final File _testClassFile;
        private final List<TestClassGroup.TestClass.TestClassMethod> _testClassMethods = new ArrayList<TestClassGroup.TestClass.TestClassMethod>();

        @Override
        public int compareTo(TestClassGroup.TestClass testClass) {
            if (testClass == null) {
                throw new NullPointerException("Test class is null");
            }
            return this._testClassFile.compareTo(testClass.getTestClassFile());
        }

        @Override
        public File getTestClassFile() {
            return this._testClassFile;
        }

        @Override
        public List<TestClassGroup.TestClass.TestClassMethod> getTestClassMethods() {
            return this._testClassMethods;
        }

        @Override
        public boolean isIgnored() {
            return false;
        }

        protected BaseTestClass(File testClassFile) {
            this._testClassFile = testClassFile;
        }

        protected void addTestClassMethod(boolean methodIgnored, String methodName) {
            this.addTestClassMethod(new TestClassGroup.TestClass.TestClassMethod(methodIgnored, methodName, this));
        }

        protected void addTestClassMethod(String methodName) {
            this.addTestClassMethod(false, methodName);
        }

        protected void addTestClassMethod(TestClassGroup.TestClass.TestClassMethod testClassMethod) {
            this._testClassMethods.add(testClassMethod);
        }
    }
}

