/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.github.webhook;

import com.liferay.jenkins.results.parser.GitCommitFactory;
import com.liferay.jenkins.results.parser.GitHubRemoteGitCommit;
import com.liferay.jenkins.results.parser.GitHubRemoteGitRepository;
import com.liferay.jenkins.results.parser.GitRepositoryFactory;
import com.liferay.jenkins.results.parser.GitUtil;
import com.liferay.jenkins.results.parser.RemoteGitBranch;
import com.liferay.jenkins.results.parser.github.webhook.Payload;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class PushEventPayload
extends Payload {
    protected GitHubRemoteGitRepository gitHubRemoteGitRepository = (GitHubRemoteGitRepository)GitRepositoryFactory.getRemoteGitRepository("github.com", this.get("repository/name"), this.get("repository/owner/login"));
    protected GitHubRemoteGitCommit headGitHubRemoteGitCommit;
    protected RemoteGitBranch pusherRemoteGitBranch;
    private static final Pattern _branchPattern = Pattern.compile("refs/heads/(.*)");

    public PushEventPayload(JSONObject jsonObject) {
        super(jsonObject);
    }

    public String getAfterSHA() {
        return this.get("after");
    }

    public String getBeforeSHA() {
        return this.get("before");
    }

    public GitHubRemoteGitCommit getHeadGitHubRemoteGitCommit() {
        if (this.headGitHubRemoteGitCommit == null) {
            this.headGitHubRemoteGitCommit = GitCommitFactory.newGitHubRemoteGitCommit(this.gitHubRemoteGitRepository.getUsername(), this.gitHubRemoteGitRepository.getName(), this.getAfterSHA());
        }
        return this.headGitHubRemoteGitCommit;
    }

    public RemoteGitBranch getPusherRemoteGitBranch() {
        if (this.pusherRemoteGitBranch == null) {
            this.pusherRemoteGitBranch = GitUtil.getRemoteGitBranch(this.getPusherBranchName(), new File("."), this.gitHubRemoteGitRepository.getRemoteURL());
        }
        return this.pusherRemoteGitBranch;
    }

    public GitHubRemoteGitRepository getRemoteGitRepository() {
        return this.gitHubRemoteGitRepository;
    }

    protected String getPusherBranchName() {
        Matcher matcher = _branchPattern.matcher(this.get("ref"));
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }
}

