/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.failure.message.generator;

import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.failure.message.generator.BaseFailureMessageGenerator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;

public class PoshiTestFailureMessageGenerator
extends BaseFailureMessageGenerator {
    private static final String _TOKEN_JAVA_LANG_EXCEPTION = "java.lang.Exception";
    private static final String _TOKEN_TRY = "Try:";
    private static final Pattern _poshiTestFailurePattern = Pattern.compile("(?:\\n.*)(Execution failed for task.*Poshi.*)\\n");

    @Override
    public Element getMessageElement(String consoleText) {
        Matcher poshiTestFailureMatcher = _poshiTestFailurePattern.matcher(consoleText);
        if (!poshiTestFailureMatcher.find()) {
            return null;
        }
        String failedPoshiTaskToken = poshiTestFailureMatcher.group(1);
        int end = consoleText.indexOf(failedPoshiTaskToken);
        end = consoleText.indexOf(_TOKEN_TRY, end);
        end = consoleText.lastIndexOf("\n", end);
        int start = consoleText.lastIndexOf(_TOKEN_JAVA_LANG_EXCEPTION, end);
        start = consoleText.lastIndexOf("\n", start);
        return Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewElement("p", null, "POSHI Test Failure: ", Dom4JUtil.getNewElement("strong", null, failedPoshiTaskToken)), this.getConsoleTextSnippetElement(consoleText, true, start, end));
    }
}

