/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.failure.message.generator;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.failure.message.generator.BaseFailureMessageGenerator;
import java.util.Map;
import org.dom4j.Element;

public class PluginGitIDFailureMessageGenerator
extends BaseFailureMessageGenerator {
    @Override
    public Element getMessageElement(Build build) {
        String consoleText = build.getConsoleText();
        if (!consoleText.contains("fatal: Could not parse object")) {
            return null;
        }
        int end = consoleText.indexOf("merge-test-results:");
        TopLevelBuild topLevelBuild = build.getTopLevelBuild();
        return Dom4JUtil.getNewElement("p", null, "Please update ", Dom4JUtil.getNewElement("strong", null, this.getGitCommitPluginsAnchorElement(topLevelBuild)), " to an existing Git ID from ", Dom4JUtil.getNewElement("strong", null, this.getPluginsBranchAnchorElement(topLevelBuild)), ".", this.getConsoleTextSnippetElementByEnd(consoleText, true, end));
    }

    protected Element getPluginsBranchAnchorElement(TopLevelBuild topLevelBuild) {
        String gitRepositoryName = topLevelBuild.getBaseGitRepositoryName();
        String pluginsGitRepositoryName = "liferay-plugins";
        if (gitRepositoryName.endsWith("-ee")) {
            pluginsGitRepositoryName = pluginsGitRepositoryName + "-ee";
        }
        Map<String, String> pluginsGitRepositoryGitDetailsTempMap = topLevelBuild.getBaseGitRepositoryDetailsTempMap();
        StringBuilder sb = new StringBuilder();
        sb.append("https://github.com/liferay/");
        sb.append(pluginsGitRepositoryName);
        sb.append("/commits/");
        sb.append(pluginsGitRepositoryGitDetailsTempMap.get("github.upstream.branch.name"));
        return Dom4JUtil.getNewAnchorElement(sb.toString(), pluginsGitRepositoryName, "/", pluginsGitRepositoryGitDetailsTempMap.get("github.upstream.branch.name"));
    }
}

