/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.failure.message.generator;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.failure.message.generator.BaseFailureMessageGenerator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;

public class PluginFailureMessageGenerator
extends BaseFailureMessageGenerator {
    private static final String _URL_BLOG = "https://in.liferay.com/web/global.engineering/blog/-/blogs/new-tests-for-the-pull-request-tester-";
    private static final Pattern _pattern = Pattern.compile("(\\d+) of \\d+ plugins? failed to compile:");

    @Override
    public Element getMessageElement(Build build) {
        String buildURL = build.getBuildURL();
        if (!buildURL.contains("portal-acceptance")) {
            return null;
        }
        String jobVariant = build.getParameterValue("JOB_VARIANT");
        if (!buildURL.contains("plugins") && !jobVariant.contains("plugins")) {
            return null;
        }
        String consoleText = build.getConsoleText();
        Matcher matcher = _pattern.matcher(consoleText);
        Element messageElement = Dom4JUtil.getNewElement("div");
        Element paragraphElement = Dom4JUtil.getNewElement("p", messageElement, new Object[0]);
        if (matcher.find()) {
            String group = matcher.group(0);
            paragraphElement.addText(group);
            Element pluginsListElement = Dom4JUtil.getNewElement("ul", messageElement, new Object[0]);
            int x = matcher.start() + group.length() + 1;
            int count = Integer.parseInt(matcher.group(1));
            for (int i = 0; i < count; ++i) {
                Element pluginListItemElement = Dom4JUtil.getNewElement("li", pluginsListElement, new Object[0]);
                if (i == 10) {
                    pluginListItemElement.addText("...");
                    break;
                }
                int y = consoleText.indexOf("\n", x);
                String pluginName = consoleText.substring(x, y);
                pluginListItemElement.addText(pluginName.replace("[echo] ", ""));
                x = y + 1;
            }
        } else {
            TopLevelBuild topLevelBuild = build.getTopLevelBuild();
            int end = consoleText.indexOf("merge-test-results:");
            Dom4JUtil.addToElement(paragraphElement, "To include a plugin fix for this pull request, ", "please edit your ", this.getGitCommitPluginsAnchorElement(topLevelBuild), ". Click ", Dom4JUtil.getNewAnchorElement(_URL_BLOG, "here"), " for more details.", this.getConsoleTextSnippetElementByEnd(consoleText, true, end));
        }
        return messageElement;
    }
}

