/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.failure.message.generator;

import com.liferay.jenkins.results.parser.failure.message.generator.BaseFailureMessageGenerator;
import org.dom4j.Element;

public class GenericFailureMessageGenerator
extends BaseFailureMessageGenerator {
    @Override
    public Element getMessageElement(String consoleText) {
        Element message = this.getExceptionSnippetElement(consoleText);
        if (message != null) {
            return message;
        }
        message = this.getMergeTestResultsSnippetElement(consoleText);
        if (message != null) {
            return message;
        }
        message = this.getBuildFailedSnippetElement(consoleText);
        if (message != null) {
            return message;
        }
        return this.getConsoleTextSnippetElementByEnd(consoleText, true, -1);
    }

    @Override
    public boolean isGenericCIFailure() {
        return true;
    }

    protected String getBuildFailedSnippet(String consoleText) {
        int end = consoleText.indexOf("BUILD FAILED");
        if (end == -1) {
            return null;
        }
        end = consoleText.indexOf("Total time:", end);
        return this.getConsoleTextSnippet(consoleText, true, end);
    }

    protected Element getBuildFailedSnippetElement(String consoleText) {
        int end = consoleText.indexOf("BUILD FAILED");
        if (end == -1) {
            return null;
        }
        end = consoleText.indexOf("Total time:", end);
        return this.getConsoleTextSnippetElementByEnd(consoleText, true, end);
    }

    protected String getExceptionSnippet(String consoleText) {
        int end = consoleText.indexOf("[exec] * Exception is:");
        if (end == -1) {
            return null;
        }
        end = consoleText.indexOf("\n", end + 500);
        return this.getConsoleTextSnippet(consoleText, true, end);
    }

    protected Element getExceptionSnippetElement(String consoleText) {
        int end = consoleText.indexOf("[exec] * Exception is:");
        if (end == -1) {
            return null;
        }
        end = consoleText.indexOf("\n", end + 500);
        return this.getConsoleTextSnippetElementByEnd(consoleText, true, end);
    }

    protected String getMergeTestResultsSnippet(String consoleText) {
        int end = consoleText.indexOf("merge-test-results:");
        if (end == -1) {
            return null;
        }
        return this.getConsoleTextSnippet(consoleText, true, end);
    }

    protected Element getMergeTestResultsSnippetElement(String consoleText) {
        int end = consoleText.indexOf("merge-test-results:");
        if (end == -1) {
            return null;
        }
        return this.getConsoleTextSnippetElementByEnd(consoleText, true, end);
    }
}

