/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BasePortalWorkspace;
import com.liferay.jenkins.results.parser.BatchPortalWorkspace;
import com.liferay.jenkins.results.parser.FunctionalBatchPortalWorkspace;
import com.liferay.jenkins.results.parser.JunitBatchPortalWorkspace;
import com.liferay.jenkins.results.parser.MethodLogger;
import com.liferay.jenkins.results.parser.PortalWorkspace;
import com.liferay.jenkins.results.parser.SimpleWorkspace;
import com.liferay.jenkins.results.parser.TopLevelPortalWorkspace;
import com.liferay.jenkins.results.parser.Workspace;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public abstract class WorkspaceFactory {
    public static Workspace newBatchWorkspace(String gitHubURL, String upstreamBranchName, String batchName, String branchSHA) {
        if (gitHubURL == null) {
            throw new RuntimeException("GitHub URL is null");
        }
        if (!BasePortalWorkspace.isPortalGitHubURL(gitHubURL)) {
            throw new RuntimeException("Unsupported GitHub URL " + gitHubURL);
        }
        if (batchName == null) {
            batchName = "default";
        }
        BatchPortalWorkspace workspace = null;
        workspace = batchName.contains("functional") ? new FunctionalBatchPortalWorkspace(gitHubURL, upstreamBranchName, branchSHA) : (batchName.contains("integration") || batchName.contains("unit") ? new JunitBatchPortalWorkspace(gitHubURL, upstreamBranchName, branchSHA) : new BatchPortalWorkspace(gitHubURL, upstreamBranchName, branchSHA));
        if (workspace == null) {
            throw new RuntimeException("Invalid workspace");
        }
        if (workspace instanceof PortalWorkspace) {
            return (PortalWorkspace)Proxy.newProxyInstance(PortalWorkspace.class.getClassLoader(), new Class[]{PortalWorkspace.class}, (InvocationHandler)new MethodLogger(workspace));
        }
        return (Workspace)Proxy.newProxyInstance(Workspace.class.getClassLoader(), new Class[]{Workspace.class}, (InvocationHandler)new MethodLogger(workspace));
    }

    public static Workspace newSimpleWorkspace() {
        SimpleWorkspace workspace = new SimpleWorkspace();
        return (Workspace)Proxy.newProxyInstance(Workspace.class.getClassLoader(), new Class[]{Workspace.class}, (InvocationHandler)new MethodLogger(workspace));
    }

    public static Workspace newTopLevelWorkspace(String gitHubURL, String upstreamBranchName) {
        if (gitHubURL == null) {
            throw new RuntimeException("GitHub URL is null");
        }
        if (!BasePortalWorkspace.isPortalGitHubURL(gitHubURL)) {
            throw new RuntimeException("Unsupported GitHub URL " + gitHubURL);
        }
        TopLevelPortalWorkspace workspace = new TopLevelPortalWorkspace(gitHubURL, upstreamBranchName);
        if (workspace instanceof PortalWorkspace) {
            return (PortalWorkspace)Proxy.newProxyInstance(PortalWorkspace.class.getClassLoader(), new Class[]{PortalWorkspace.class}, (InvocationHandler)new MethodLogger(workspace));
        }
        return (Workspace)Proxy.newProxyInstance(Workspace.class.getClassLoader(), new Class[]{Workspace.class}, (InvocationHandler)new MethodLogger(workspace));
    }
}

