/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuild;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.failure.message.generator.FailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.GenericFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.GradleTaskFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.RebaseFailureMessageGenerator;
import com.liferay.jenkins.results.parser.failure.message.generator.SourceFormatFailureMessageGenerator;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.json.JSONObject;

public class ValidationBuild
extends BaseBuild {
    private static final FailureMessageGenerator[] _FAILURE_MESSAGE_GENERATORS = new FailureMessageGenerator[]{new RebaseFailureMessageGenerator(), new SourceFormatFailureMessageGenerator(), new GenericFailureMessageGenerator()};
    private static final Pattern _consoleResultPattern = Pattern.compile("Subrepository task (FAILED|SUCCESSFUL)");

    @Override
    public void addTimelineData(BaseBuild.TimelineData timelineData) {
        timelineData.addTimelineData(this);
    }

    @Override
    public URL getArtifactsBaseURL() {
        return null;
    }

    @Override
    public Element getGitHubMessageElement() {
        this.update();
        Element rootElement = Dom4JUtil.getNewElement("html", null, this.getResultMessageElement(), this.getBuildTimeElement(), Dom4JUtil.getNewElement("h4", null, "Base Branch:"), this.getBaseBranchDetailsElement());
        String consoleText = this.getConsoleText();
        String[] consoleSnippets = consoleText.split("Executing subrepository task ");
        if (consoleSnippets.length > 1) {
            Dom4JUtil.addToElement(rootElement, Dom4JUtil.getNewElement("h6", null, "Task Summary:"));
            Element taskSummaryListElement = Dom4JUtil.getNewElement("ul", rootElement, new Object[0]);
            ArrayList<String> junitTaskNames = new ArrayList<String>();
            for (int i = 1; i < consoleSnippets.length; ++i) {
                String consoleSnippet = consoleSnippets[i];
                if (consoleSnippet.contains("merge-test-results:")) {
                    junitTaskNames.add(this.getTaskName(consoleSnippet));
                    continue;
                }
                Dom4JUtil.addToElement(taskSummaryListElement, this.getTaskSummaryIndexElement(consoleSnippet));
            }
            if (!junitTaskNames.isEmpty()) {
                List<TestResult> testResults = this.getTestResults(null);
                String taskResult = "SUCCESSFUL";
                Element messageElement = null;
                for (TestResult testResult : testResults) {
                    if (!testResult.isFailing()) continue;
                    taskResult = "FAILED";
                    messageElement = Dom4JUtil.toCodeSnippetElement("Test failures detected. See below for details.");
                    break;
                }
                Dom4JUtil.addToElement(taskSummaryListElement, this.getTaskSummaryIndexElement(StringUtils.join(junitTaskNames, (String)"/"), taskResult, messageElement));
            }
            Dom4JUtil.addToElement(rootElement, this.getFullConsoleClickHereElement(), Dom4JUtil.getNewElement("hr"), this.getTestSummaryElement());
        } else {
            Dom4JUtil.addToElement(rootElement, this.getFailureMessageElement(), this.getFullConsoleClickHereElement());
        }
        return rootElement;
    }

    @Override
    public List<TestResult> getTestResults(String testStatus) {
        String status = this.getStatus();
        if (!status.equals("completed")) {
            return Collections.emptyList();
        }
        JSONObject testReportJSONObject = this.getTestReportJSONObject(false);
        return this.getTestResults(this, testReportJSONObject.getJSONArray("suites"), testStatus);
    }

    protected ValidationBuild(String url) {
        this(url, null);
    }

    protected ValidationBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    protected Element getBaseBranchDetailsElement() {
        String baseBranchURL = JenkinsResultsParserUtil.combine("https://github.com/liferay/", this.getBaseGitRepositoryName(), "/tree/", this.getBranchName());
        String baseGitRepositoryName = this.getBaseGitRepositoryName();
        String baseGitRepositorySHA = null;
        baseGitRepositorySHA = !baseGitRepositoryName.equals("liferay-jenkins-ee") && baseGitRepositoryName.endsWith("-ee") ? this.getBaseGitRepositorySHA(baseGitRepositoryName.substring(0, baseGitRepositoryName.length() - 3)) : this.getBaseGitRepositorySHA(baseGitRepositoryName);
        Element baseBranchDetailsElement = Dom4JUtil.getNewElement("p", null, "Branch Name: ", Dom4JUtil.getNewAnchorElement(baseBranchURL, this.getBranchName()));
        if (baseGitRepositorySHA != null) {
            String baseGitRepositoryCommitURL = "https://github.com/liferay/" + baseGitRepositoryName + "/commit/" + baseGitRepositorySHA;
            Dom4JUtil.addToElement(baseBranchDetailsElement, Dom4JUtil.getNewElement("br"), "Branch GIT ID: ", Dom4JUtil.getNewAnchorElement(baseGitRepositoryCommitURL, baseGitRepositorySHA));
        }
        return baseBranchDetailsElement;
    }

    @Override
    protected FailureMessageGenerator[] getFailureMessageGenerators() {
        return _FAILURE_MESSAGE_GENERATORS;
    }

    @Override
    protected Element getGitHubMessageJobResultsElement() {
        return null;
    }

    protected Element getGitHubMessageTestResultsElement() {
        int failCount = this.getTestCountByStatus("FAILURE");
        int successCount = this.getTestCountByStatus("SUCCESS");
        return Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewElement("p", null, String.valueOf(successCount), JenkinsResultsParserUtil.getNounForm(successCount, " Tests", " Test"), " Passed.", Dom4JUtil.getNewElement("br"), String.valueOf(failCount), JenkinsResultsParserUtil.getNounForm(failCount, " Tests", " Test"), " Failed."));
    }

    protected Element getResultMessageElement() {
        Element resultMessageElement = Dom4JUtil.getNewElement("h1");
        String result = this.getResult();
        if (!result.equals("SUCCESS")) {
            resultMessageElement.addText("Validation FAILED.");
        } else {
            resultMessageElement.addText("Validation PASSED. Running batch tests.");
        }
        return resultMessageElement;
    }

    protected String getTaskName(String console) {
        return console.substring(0, console.indexOf("\n"));
    }

    protected String getTaskResultIcon(String result) {
        if (result.equals("FAILED")) {
            return " :x:";
        }
        if (result.equals("SUCCESSFUL")) {
            return " :heavy_check_mark:";
        }
        return "";
    }

    protected Element getTaskSummaryIndexElement(String console) {
        String taskName = this.getTaskName(console);
        Matcher matcher = _consoleResultPattern.matcher(console);
        String taskResult = "FAILED";
        if (matcher.find()) {
            taskResult = matcher.group(1);
        }
        Element taskSummaryIndexFailureMessageElement = null;
        if (taskResult.equals("FAILED")) {
            taskSummaryIndexFailureMessageElement = this.getTaskSummaryIndexFailureMessageElement(console, taskName);
        }
        return this.getTaskSummaryIndexElement(taskName, taskResult, taskSummaryIndexFailureMessageElement);
    }

    protected Element getTaskSummaryIndexElement(String taskName, String taskResult, Element messageElement) {
        return Dom4JUtil.getNewElement("li", null, taskName, " - ", this.getTaskResultIcon(taskResult), messageElement);
    }

    protected Element getTaskSummaryIndexFailureMessageElement(String console, String taskName) {
        SourceFormatFailureMessageGenerator sourceFormatFailureMessageGenerator;
        Element messageElement = null;
        if (taskName.contains("subrepository-source-format") && (messageElement = (sourceFormatFailureMessageGenerator = new SourceFormatFailureMessageGenerator()).getMessageElement(console)) != null) {
            return messageElement;
        }
        GradleTaskFailureMessageGenerator gradleTaskFailureMessageGenerator = new GradleTaskFailureMessageGenerator();
        messageElement = gradleTaskFailureMessageGenerator.getMessageElement(console);
        if (messageElement != null) {
            return messageElement;
        }
        GenericFailureMessageGenerator genericFailureMessageGenerator = new GenericFailureMessageGenerator();
        return genericFailureMessageGenerator.getMessageElement(console);
    }

    protected Element getTestSummaryElement() {
        Element testSummaryElement = Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewElement("h6", null, "Test Results:"));
        List<TestResult> testResults = this.getTestResults(null);
        boolean noTestResults = testResults.isEmpty();
        if (testResults.size() == 1) {
            TestResult testResult = testResults.get(0);
            String className = testResult.getClassName();
            noTestResults = className.equals("com.liferay.jenkins.Jenkins");
        }
        if (noTestResults) {
            Dom4JUtil.addToElement(testSummaryElement, Dom4JUtil.getNewElement("h5", null, "No tests were run."));
        } else {
            Dom4JUtil.addToElement(testSummaryElement, Dom4JUtil.getNewElement("div", null, this.getGitHubMessageTestResultsElement()));
            ArrayList<Element> failureElements = new ArrayList<Element>();
            for (TestResult testResult : this.getTestResults(null)) {
                if (!testResult.isFailing()) continue;
                failureElements.add(testResult.getGitHubElement());
            }
            if (!failureElements.isEmpty()) {
                Dom4JUtil.getOrderedListElement(failureElements, testSummaryElement, 5);
            }
            Element testReportElement = Dom4JUtil.getNewElement("h5", null, "For all test results, click ", Dom4JUtil.getNewAnchorElement(this.getBuildURL() + "/testReport", "here"), ".");
            Dom4JUtil.addToElement(testSummaryElement, testReportElement);
        }
        return testSummaryElement;
    }
}

