/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuildData;
import com.liferay.jenkins.results.parser.BaseBuildRunner;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.JobFactory;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class TestResultsConsistencyReportControllerBuildRunner<S extends BaseBuildData>
extends BaseBuildRunner<S, Workspace> {
    private static final Pattern _testSuiteBranchNameDescriptionPattern = Pattern.compile("(?<testSuite>[^\\(]*)\\((?<branchName>[^\\)]*)\\)");
    private List<Pair<String, String>> _selectedTestSuiteBranchNamePairs;

    @Override
    public void run() {
        this.keepJenkinsBuild(true);
        this.invokeTestSuiteBuilds();
    }

    @Override
    public void tearDown() {
    }

    protected TestResultsConsistencyReportControllerBuildRunner(S buildData) {
        super(buildData);
    }

    protected String getInvocationCohortName() {
        String invocationCohortName = System.getenv("INVOCATION_COHORT_NAME");
        if (invocationCohortName != null && !invocationCohortName.isEmpty()) {
            return invocationCohortName;
        }
        Object buildData = this.getBuildData();
        return buildData.getCohortName();
    }

    protected String getJobURL() {
        String mostAvailableMasterURL = JenkinsResultsParserUtil.getMostAvailableMasterURL(JenkinsResultsParserUtil.combine("http://" + this.getInvocationCohortName() + ".liferay.com"), 1);
        return JenkinsResultsParserUtil.combine(mostAvailableMasterURL, "/job/test-results-consistency-report");
    }

    @Override
    protected void initWorkspace() {
        this.setWorkspace(WorkspaceFactory.newSimpleWorkspace());
    }

    protected void invokeTestSuiteBuilds() {
        String jenkinsAuthenticationToken;
        List<Pair<String, String>> selectedTestSuiteBranchNamePairs = this._getSelectedTestSuiteBranchNamePairs();
        if (selectedTestSuiteBranchNamePairs.isEmpty()) {
            System.out.println("There are no test suites to run at this time.");
            return;
        }
        try {
            Properties buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            jenkinsAuthenticationToken = buildProperties.getProperty("jenkins.authentication.token");
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        BaseBuildData buildData = (BaseBuildData)this.getBuildData();
        ArrayList<String> invokedTestSuiteBranchNamePairDescriptions = new ArrayList<String>();
        for (Pair<String, String> testSuiteBranchNamePair : selectedTestSuiteBranchNamePairs) {
            String jobURL = this.getJobURL();
            StringBuilder sb = new StringBuilder();
            sb.append(jobURL);
            sb.append("/buildWithParameters?");
            sb.append("token=");
            sb.append(jenkinsAuthenticationToken);
            HashMap<String, String> invocationParameters = new HashMap<String, String>();
            String testSuite = (String)testSuiteBranchNamePair.getKey();
            String branchName = (String)testSuiteBranchNamePair.getValue();
            invocationParameters.put("CI_TEST_SUITE", testSuite);
            invocationParameters.put("JENKINS_GITHUB_BRANCH_NAME", buildData.getJenkinsGitHubBranchName());
            invocationParameters.put("JENKINS_GITHUB_BRANCH_USERNAME", buildData.getJenkinsGitHubUsername());
            invocationParameters.put("PORTAL_UPSTREAM_BRANCH_NAME", branchName);
            invocationParameters.putAll(buildData.getBuildParameters());
            for (Map.Entry invocationParameter : invocationParameters.entrySet()) {
                if (invocationParameter.getValue() == null) continue;
                sb.append("&");
                sb.append((String)invocationParameter.getKey());
                sb.append("=");
                sb.append((String)invocationParameter.getValue());
            }
            String testSuiteBranchNamePairDescription = JenkinsResultsParserUtil.combine(testSuite, "(", branchName, ")");
            try {
                JenkinsResultsParserUtil.toString(sb.toString());
                System.out.println(JenkinsResultsParserUtil.combine("Job for '", testSuiteBranchNamePairDescription, "' was invoked at ", jobURL));
                invokedTestSuiteBranchNamePairDescriptions.add(testSuiteBranchNamePairDescription);
            }
            catch (IOException ioException) {
                System.out.println(JenkinsResultsParserUtil.combine("Unable to invoke a new build for test suite, '", testSuiteBranchNamePairDescription, "'"));
                ioException.printStackTrace();
            }
        }
        buildData.setBuildDescription(JenkinsResultsParserUtil.join(", ", invokedTestSuiteBranchNamePairDescriptions));
        this.updateBuildDescription();
    }

    private List<Build> _getBuildHistory() {
        BaseBuildData buildData = (BaseBuildData)this.getBuildData();
        Build build = BuildFactory.newBuild(buildData.getBuildURL(), null);
        Job job = JobFactory.newJob(buildData.getJobName());
        return job.getBuildHistory(build.getJenkinsMaster());
    }

    private List<Pair<String, String>> _getBuildTestSuiteBranchNamePairs(Build build) {
        String buildDescription = build.getBuildDescription();
        if (buildDescription == null || buildDescription.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Pair<String, String>> buildTestSuiteBranchNamePairs = new ArrayList<Pair<String, String>>();
        for (String buildTestSuiteBranchNamePairDescription : buildDescription.split("\\s*,\\s*")) {
            Matcher matcher = _testSuiteBranchNameDescriptionPattern.matcher(buildTestSuiteBranchNamePairDescription);
            if (!matcher.matches()) continue;
            buildTestSuiteBranchNamePairs.add((Pair<String, String>)new ImmutablePair((Object)matcher.group("testSuite"), (Object)matcher.group("branchName")));
        }
        return buildTestSuiteBranchNamePairs;
    }

    private Map<Pair<String, String>, Long> _getCandidateTestSuiteStaleDurations() {
        Properties buildProperties;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        LinkedHashMap<Pair<String, String>, Long> candidateTestSuiteStaleDurations = new LinkedHashMap<Pair<String, String>, Long>();
        for (Pair<String, String> testSuiteBranchNamePair : this._getTestSuiteBranchNamePairs()) {
            String suiteStaleDuration = buildProperties.getProperty(JenkinsResultsParserUtil.combine("portal.testsuite.upstream.stale.duration[", (String)testSuiteBranchNamePair.getValue(), "][", (String)testSuiteBranchNamePair.getKey(), "]"));
            if (suiteStaleDuration == null) continue;
            candidateTestSuiteStaleDurations.put(testSuiteBranchNamePair, Long.parseLong(suiteStaleDuration) * 60L * 1000L);
        }
        return candidateTestSuiteStaleDurations;
    }

    private Map<Pair<String, String>, Long> _getLatestTestSuiteStartTimes() {
        List<Build> builds = this._getBuildHistory();
        Object buildData = this.getBuildData();
        Build currentBuild = BuildFactory.newBuild(buildData.getBuildURL(), null);
        builds.remove(currentBuild);
        LinkedHashMap<Pair<String, String>, Long> latestTestSuiteStartTimes = new LinkedHashMap<Pair<String, String>, Long>();
        block0: for (Pair<String, String> testSuiteBranchNamePair : this._getTestSuiteBranchNamePairs()) {
            for (Build build : builds) {
                List<Pair<String, String>> buildTestSuiteBranchNamePairs = this._getBuildTestSuiteBranchNamePairs(build);
                if (!buildTestSuiteBranchNamePairs.contains(testSuiteBranchNamePair)) continue;
                latestTestSuiteStartTimes.put(testSuiteBranchNamePair, build.getStartTime());
                continue block0;
            }
        }
        return latestTestSuiteStartTimes;
    }

    private List<Pair<String, String>> _getSelectedTestSuiteBranchNamePairs() {
        if (this._selectedTestSuiteBranchNamePairs != null) {
            return this._selectedTestSuiteBranchNamePairs;
        }
        this._selectedTestSuiteBranchNamePairs = new ArrayList<Pair<String, String>>();
        Map<Pair<String, String>, Long> candidateTestSuiteStaleDurations = this._getCandidateTestSuiteStaleDurations();
        Map<Pair<String, String>, Long> latestTestSuiteStartTimes = this._getLatestTestSuiteStartTimes();
        BaseBuildData buildData = (BaseBuildData)this.getBuildData();
        Long startTime = buildData.getStartTime();
        for (Map.Entry<Pair<String, String>, Long> entry : candidateTestSuiteStaleDurations.entrySet()) {
            Pair<String, String> testSuiteBranchNamePair = entry.getKey();
            if (!latestTestSuiteStartTimes.containsKey(testSuiteBranchNamePair)) {
                this._selectedTestSuiteBranchNamePairs.add(testSuiteBranchNamePair);
                continue;
            }
            Long testSuiteIdleDuration = startTime - latestTestSuiteStartTimes.get(testSuiteBranchNamePair);
            if (testSuiteIdleDuration <= entry.getValue()) continue;
            this._selectedTestSuiteBranchNamePairs.add(testSuiteBranchNamePair);
        }
        return this._selectedTestSuiteBranchNamePairs;
    }

    private List<Pair<String, String>> _getTestSuiteBranchNamePairs() {
        ArrayList<Pair<String, String>> testSuiteBranchNamePairs = new ArrayList<Pair<String, String>>();
        try {
            List<String> testSuiteNames = JenkinsResultsParserUtil.getBuildPropertyAsList(true, "test.results.consistency.report.suites");
            for (String testSuiteName : testSuiteNames) {
                List<String> branchNames = JenkinsResultsParserUtil.getBuildPropertyAsList(true, "test.results.consistency.report.branches[" + testSuiteName + "]");
                for (String branchName : branchNames) {
                    testSuiteBranchNamePairs.add((Pair<String, String>)new ImmutablePair((Object)testSuiteName, (Object)branchName));
                }
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        return testSuiteBranchNamePairs;
    }
}

