/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BatchDependentJob;
import com.liferay.jenkins.results.parser.GitRepositoryJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.SubrepositoryGitWorkingDirectory;
import com.liferay.jenkins.results.parser.SubrepositoryTestClassJob;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.SegmentTestClassGroup;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class SubrepositoryGitRepositoryJob
extends GitRepositoryJob
implements BatchDependentJob,
SubrepositoryTestClassJob {
    protected PortalGitWorkingDirectory portalGitWorkingDirectory;
    protected boolean validationRequired;

    @Override
    public List<AxisTestClassGroup> getDependentAxisTestClassGroups() {
        ArrayList<AxisTestClassGroup> axisTestClassGroups = new ArrayList<AxisTestClassGroup>();
        for (BatchTestClassGroup batchTestClassGroup : this.getDependentBatchTestClassGroups()) {
            axisTestClassGroups.addAll(batchTestClassGroup.getAxisTestClassGroups());
        }
        return axisTestClassGroups;
    }

    @Override
    public Set<String> getDependentBatchNames() {
        return this.getFilteredBatchNames(this.getRawDependentBatchNames());
    }

    @Override
    public List<BatchTestClassGroup> getDependentBatchTestClassGroups() {
        return this.getBatchTestClassGroups(this.getRawDependentBatchNames());
    }

    @Override
    public Set<String> getDependentSegmentNames() {
        return this.getFilteredSegmentNames(this.getRawDependentBatchNames());
    }

    @Override
    public List<SegmentTestClassGroup> getDependentSegmentTestClassGroups() {
        return this.getSegmentTestClassGroups(this.getRawDependentBatchNames());
    }

    @Override
    public Set<String> getDistTypes() {
        String testBatchDistAppServers = JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.dist.app.servers");
        return this.getSetFromString(testBatchDistAppServers);
    }

    @Override
    public GitWorkingDirectory getGitWorkingDirectory() {
        if (this.gitWorkingDirectory != null) {
            return this.gitWorkingDirectory;
        }
        this.checkGitRepositoryDir();
        this.gitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(this.getBranchName(), this.gitRepositoryDir.getPath());
        return this.gitWorkingDirectory;
    }

    @Override
    public PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        if (this.portalGitWorkingDirectory == null) {
            this.portalGitWorkingDirectory = GitWorkingDirectoryFactory.newPortalGitWorkingDirectory(this.getBranchName());
        }
        return this.portalGitWorkingDirectory;
    }

    @Override
    public SubrepositoryGitWorkingDirectory getSubrepositoryGitWorkingDirectory() {
        GitWorkingDirectory gitWorkingDirectory = this.getGitWorkingDirectory();
        if (!(gitWorkingDirectory instanceof SubrepositoryGitWorkingDirectory)) {
            throw new RuntimeException("Invalid subrepository Git working directory");
        }
        return (SubrepositoryGitWorkingDirectory)gitWorkingDirectory;
    }

    @Override
    public boolean isValidationRequired() {
        return this.validationRequired;
    }

    @Override
    public void setGitRepositoryDir(File repositoryDir) {
        String dirName = repositoryDir.getName();
        if (!dirName.endsWith("-private")) {
            dirName = dirName + "-private";
            repositoryDir = new File(repositoryDir.getParentFile(), dirName);
        }
        super.setGitRepositoryDir(repositoryDir);
    }

    protected SubrepositoryGitRepositoryJob(String jobName, Job.BuildProfile buildProfile, String repositoryName) {
        super(jobName, buildProfile);
        this.gitWorkingDirectory = GitWorkingDirectoryFactory.newSubrepositoryGitWorkingDirectory(jobName, repositoryName);
        this.setGitRepositoryDir(this.gitWorkingDirectory.getWorkingDirectory());
        this.checkGitRepositoryDir();
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        this.jobPropertiesFiles.add(new File(portalGitWorkingDirectory.getWorkingDirectory(), "test.properties"));
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build properties", ioException);
        }
        this.jobPropertiesFiles.add(new File(this.gitRepositoryDir, "test.properties"));
        this.jobPropertiesFiles.add(new File(JenkinsResultsParserUtil.combine(buildProperties.getProperty("base.repository.dir"), "/liferay-jenkins-ee/commands/dependencies", "/test-subrepository-batch.properties")));
        this.readJobProperties();
    }

    @Override
    protected Set<String> getRawBatchNames() {
        String batchNames = JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.names", this.getBranchName());
        return this.getSetFromString(batchNames);
    }

    protected Set<String> getRawDependentBatchNames() {
        String dependentBatchNames = JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.names.smoke", this.getBranchName());
        if (JenkinsResultsParserUtil.isNullOrEmpty(dependentBatchNames)) {
            return new HashSet<String>();
        }
        return this.getSetFromString(dependentBatchNames);
    }
}

