/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.SubrepositoryGitRepositoryJob;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import java.util.Set;

public class SubrepositoryAcceptancePullRequestJob
extends SubrepositoryGitRepositoryJob
implements TestSuiteJob {
    private final String _testSuiteName;

    public SubrepositoryAcceptancePullRequestJob(String jobName, Job.BuildProfile buildProfile, String testSuiteName, String repositoryName) {
        super(jobName, buildProfile, repositoryName);
        this._testSuiteName = testSuiteName;
        this._setValidationRequired();
    }

    @Override
    public Set<String> getDistTypes() {
        String testBatchDistAppServers = JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.dist.app.servers", this.getTestSuiteName());
        return this.getSetFromString(testBatchDistAppServers);
    }

    @Override
    public String getTestSuiteName() {
        return this._testSuiteName;
    }

    @Override
    protected Set<String> getRawBatchNames() {
        String batchNames = JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.names", this.getBranchName(), this.getTestSuiteName());
        if (JenkinsResultsParserUtil.isNullOrEmpty(batchNames)) {
            return super.getRawBatchNames();
        }
        return this.getSetFromString(batchNames);
    }

    @Override
    protected Set<String> getRawDependentBatchNames() {
        String dependentBatchNames = JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.names.smoke", this.getBranchName(), this.getTestSuiteName());
        if (JenkinsResultsParserUtil.isNullOrEmpty(dependentBatchNames)) {
            return super.getRawDependentBatchNames();
        }
        return this.getSetFromString(dependentBatchNames);
    }

    private void _setValidationRequired() {
        String testRunValidationProperty = JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.run.validation", this.getTestSuiteName());
        this.validationRequired = Boolean.parseBoolean(testRunValidationProperty);
    }
}

