/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONObject;

public class StopWatchRecord
implements Comparable<StopWatchRecord> {
    private Set<StopWatchRecord> _childStopWatchRecords;
    private final JSONObject _jsonObject;
    private StopWatchRecord _parentStopWatchRecord;

    public StopWatchRecord(JSONObject jsonObject) {
        this._jsonObject = jsonObject;
    }

    public StopWatchRecord(String name, long startTimestamp) {
        this._jsonObject = new JSONObject();
        this._jsonObject.put("name", (Object)name);
        this._jsonObject.put("startTimestamp", startTimestamp);
    }

    public void addChildStopWatchRecord(StopWatchRecord newChildStopWatchRecord) {
        if (this._childStopWatchRecords == null) {
            this._childStopWatchRecords = new TreeSet<StopWatchRecord>();
        }
        for (StopWatchRecord childStopWatchRecord : this._childStopWatchRecords) {
            if (!childStopWatchRecord.isParentOf(newChildStopWatchRecord)) continue;
            childStopWatchRecord.addChildStopWatchRecord(newChildStopWatchRecord);
            return;
        }
        newChildStopWatchRecord.setParentStopWatchRecord(this);
        this._childStopWatchRecords.add(newChildStopWatchRecord);
    }

    @Override
    public int compareTo(StopWatchRecord stopWatchRecord) {
        Long startTimestamp = this.getStartTimestamp();
        int compareToValue = startTimestamp.compareTo(stopWatchRecord.getStartTimestamp());
        if (compareToValue != 0) {
            return compareToValue;
        }
        Long duration = this.getDuration();
        Long stopWatchRecordDuration = stopWatchRecord.getDuration();
        if (duration == null && stopWatchRecordDuration != null) {
            return -1;
        }
        if (duration != null && stopWatchRecordDuration == null) {
            return 1;
        }
        if (duration != null && stopWatchRecordDuration != null) {
            compareToValue = -1 * duration.compareTo(stopWatchRecordDuration);
        }
        if (compareToValue != 0) {
            return compareToValue;
        }
        String name = this.getName();
        return name.compareTo(stopWatchRecord.getName());
    }

    public Set<StopWatchRecord> getChildStopWatchRecords() {
        return this._childStopWatchRecords;
    }

    public int getDepth() {
        if (this._parentStopWatchRecord == null) {
            return 0;
        }
        return this._parentStopWatchRecord.getDepth() + 1;
    }

    public Long getDuration() {
        if (!this._jsonObject.has("duration")) {
            return null;
        }
        return this._jsonObject.getLong("duration");
    }

    public JSONObject getJSONObject() {
        JSONArray childStopWatchRecordJSONArray = new JSONArray();
        if (this._childStopWatchRecords != null) {
            for (StopWatchRecord childStopWatchRecord : this._childStopWatchRecords) {
                childStopWatchRecordJSONArray.put((Object)childStopWatchRecord.getJSONObject());
            }
        }
        JSONObject jsonObject = new JSONObject();
        if (childStopWatchRecordJSONArray.length() > 0) {
            jsonObject.put("childStopWatchRecords", (Object)childStopWatchRecordJSONArray);
        }
        jsonObject.put("duration", (Object)this.getDuration());
        jsonObject.put("name", (Object)this.getName());
        jsonObject.put("startTimestamp", (Object)this.getStartTimestamp());
        return jsonObject;
    }

    public String getName() {
        return this._jsonObject.getString("name");
    }

    public StopWatchRecord getParentStopWatchRecord() {
        return this._parentStopWatchRecord;
    }

    public String getShortName() {
        String shortName = this.getName();
        StopWatchRecord parentStopWatchRecord = this.getParentStopWatchRecord();
        if (parentStopWatchRecord == null) {
            return shortName;
        }
        return shortName.replace(parentStopWatchRecord.getName(), "");
    }

    public Long getStartTimestamp() {
        return this._jsonObject.getLong("startTimestamp");
    }

    public boolean isParentOf(StopWatchRecord stopWatchRecord) {
        if (this == stopWatchRecord) {
            return false;
        }
        Long duration = this.getDuration();
        Long stopWatchRecordDuration = stopWatchRecord.getDuration();
        if (duration != null && stopWatchRecordDuration == null) {
            return false;
        }
        Long startTimestamp = this.getStartTimestamp();
        Long stopWatchRecordStartTimestamp = stopWatchRecord.getStartTimestamp();
        if (startTimestamp <= stopWatchRecordStartTimestamp) {
            if (duration == null) {
                return true;
            }
            Long endTimestamp = startTimestamp + duration;
            Long stopWatchRecordEndTimestamp = stopWatchRecordStartTimestamp + stopWatchRecordDuration;
            if (endTimestamp >= stopWatchRecordEndTimestamp) {
                return true;
            }
        }
        return false;
    }

    public void setDuration(long duration) {
        this._jsonObject.put("duration", duration);
    }

    public String toString() {
        return JenkinsResultsParserUtil.combine(this.getName(), " started at ", JenkinsResultsParserUtil.toDateString(new Date(this.getStartTimestamp())), " and ran for ", JenkinsResultsParserUtil.toDurationString(this.getDuration()), ".");
    }

    protected void setParentStopWatchRecord(StopWatchRecord stopWatchRecord) {
        this._parentStopWatchRecord = stopWatchRecord;
    }
}

