/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;

public class SecurePrintStream
extends PrintStream {
    private static final int _MAX_PRINT_LINE_LENGTH = 25000;
    private final PrintStream _printStream;

    public SecurePrintStream(PrintStream printStream) {
        super(printStream, true);
        this._printStream = printStream;
    }

    @Override
    public PrintStream append(char c) {
        this._printStream.append(c);
        return this;
    }

    @Override
    public PrintStream append(CharSequence charSequence) {
        String redactedString = this._redact(charSequence.toString());
        if (redactedString != null) {
            this._printStream.append(redactedString);
        } else {
            this._printStream.append(charSequence);
        }
        return this;
    }

    @Override
    public PrintStream append(CharSequence charSequence, int start, int end) {
        return this.append(charSequence.subSequence(start, end));
    }

    @Override
    public void flush() {
        this._printStream.flush();
    }

    @Override
    public void print(boolean b) {
        this._printStream.print(b);
    }

    @Override
    public void print(char c) {
        this._printStream.print(c);
    }

    @Override
    public void print(char[] chars) {
        String redactedString = this._redact(new String(chars));
        if (redactedString != null) {
            this._print(redactedString, false);
            return;
        }
        this._printStream.print(chars);
    }

    @Override
    public void print(double d) {
        String redactedString = this._redact(String.valueOf(d));
        if (redactedString != null) {
            this._printStream.print(redactedString);
            return;
        }
        this._printStream.print(d);
    }

    @Override
    public void print(float f) {
        String redactedString = this._redact(String.valueOf(f));
        if (redactedString != null) {
            this._printStream.print(redactedString);
            return;
        }
        this._printStream.print(f);
    }

    @Override
    public void print(int i) {
        String redactedString = this._redact(String.valueOf(i));
        if (redactedString != null) {
            this._printStream.print(redactedString);
            return;
        }
        this._printStream.print(i);
    }

    @Override
    public void print(long l) {
        String redactedString = this._redact(String.valueOf(l));
        if (redactedString != null) {
            this._printStream.println(redactedString);
            return;
        }
        this._printStream.print(l);
    }

    @Override
    public void print(Object object) {
        String redactedString;
        if (object == null) {
            this._printStream.print("null");
        }
        if ((redactedString = this._redact(object.toString())) != null) {
            this._print(redactedString, false);
            return;
        }
        this._printStream.print(object);
    }

    @Override
    public void print(String string) {
        String redactedString = this._redact(string);
        if (redactedString != null) {
            this._print(redactedString, false);
            return;
        }
        this._print(string, false);
    }

    @Override
    public void println() {
        this._printStream.println();
    }

    @Override
    public void println(boolean b) {
        this._printStream.println(b);
    }

    @Override
    public void println(char c) {
        this._printStream.println(c);
    }

    @Override
    public void println(char[] chars) {
        String redactedString = this._redact(new String(chars));
        if (redactedString != null) {
            this._print(redactedString, true);
            return;
        }
        this._printStream.println(chars);
    }

    @Override
    public void println(double d) {
        String redactedString = this._redact(String.valueOf(d));
        if (redactedString != null) {
            this._printStream.println(redactedString);
            return;
        }
        this._printStream.println(d);
    }

    @Override
    public void println(float f) {
        String redactedString = this._redact(String.valueOf(f));
        if (redactedString != null) {
            this._printStream.println(redactedString);
            return;
        }
        this._printStream.println(f);
    }

    @Override
    public void println(int i) {
        String redactedString = this._redact(String.valueOf(i));
        if (redactedString != null) {
            this._printStream.println(redactedString);
            return;
        }
        this._printStream.println(i);
    }

    @Override
    public void println(long l) {
        String redactedString = this._redact(String.valueOf(l));
        if (redactedString != null) {
            this._printStream.println(redactedString);
            return;
        }
        this._printStream.println(l);
    }

    @Override
    public void println(Object object) {
        String redactedString;
        if (object == null) {
            this._printStream.println("null");
        }
        if ((redactedString = this._redact(object.toString())) != null) {
            this.println(redactedString);
            return;
        }
        this._printStream.println(object);
    }

    @Override
    public void println(String string) {
        String redactedString = this._redact(string);
        if (redactedString != null) {
            this._print(redactedString, true);
        } else {
            this._print(string, true);
        }
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        String redactedString = this._redact(new String(bytes));
        if (redactedString != null) {
            this._print(redactedString, false);
            return;
        }
        this._printStream.write(bytes);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) {
        String redactedString = this._redact(new String(Arrays.copyOfRange(buffer, offset, offset + length)));
        if (redactedString != null) {
            this._print(redactedString, false);
            return;
        }
        this._printStream.write(buffer, offset, length);
    }

    @Override
    public void write(int b) {
        String redactedString = this._redact(String.valueOf(b));
        if (redactedString != null) {
            this._print(redactedString, false);
            return;
        }
        this._printStream.write(b);
    }

    private void _print(String string, boolean appendNewLine) {
        if (string == null && appendNewLine) {
            this._printStream.println();
            return;
        }
        String[] lines = string.split("\n");
        if (lines.length == 0) {
            if (!string.isEmpty()) {
                this._printStream.print(string);
            }
            if (appendNewLine) {
                this._printStream.println();
            }
            return;
        }
        String lastLine = lines[lines.length - 1];
        for (String line : lines) {
            if (line.length() > 25000) {
                this._printStream.print(line.substring(0, 25000));
                this._printStream.print(JenkinsResultsParserUtil.combine("[TRUNCATED ", String.valueOf(line.length() - 25000), " CHARACTERS]"));
                this._printStream.flush();
            } else {
                this._printStream.print(line);
            }
            if (line == lastLine && (line != lastLine || !appendNewLine)) continue;
            this._printStream.println();
        }
    }

    private String _redact(String string) {
        if (string == null) {
            return null;
        }
        String redactedString = JenkinsResultsParserUtil.redact(string);
        if (string.equals(redactedString)) {
            return null;
        }
        return redactedString;
    }
}

