/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalBatchBuildData;
import com.liferay.jenkins.results.parser.PortalBatchBuildRunner;
import com.liferay.jenkins.results.parser.PortalWorkspace;
import com.liferay.jenkins.results.parser.PortalWorkspaceGitRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RootCauseAnalysisBatchBuildRunner<T extends PortalBatchBuildData, S extends PortalWorkspace>
extends PortalBatchBuildRunner<T, S> {
    private static final String _NAME_BUILD_PARAMETER_PORTAL_CHERRY_PICK_SHAS = "PORTAL_CHERRY_PICK_SHAS";

    protected RootCauseAnalysisBatchBuildRunner(T portalBatchBuildData) {
        super(portalBatchBuildData);
    }

    @Override
    protected void setUpWorkspace() {
        super.setUpWorkspace();
        List<String> portalCherryPickSHAs = this._getPortalCherryPickSHAs();
        if (portalCherryPickSHAs.isEmpty()) {
            return;
        }
        PortalWorkspace portalWorkspace = (PortalWorkspace)this.getWorkspace();
        PortalWorkspaceGitRepository portalWorkspaceGitRepository = portalWorkspace.getPrimaryPortalWorkspaceGitRepository();
        GitWorkingDirectory gitWorkingDirectory = portalWorkspaceGitRepository.getGitWorkingDirectory();
        for (String portalCherryPickSHA : portalCherryPickSHAs) {
            gitWorkingDirectory.cherryPick(portalCherryPickSHA);
        }
    }

    private List<String> _getPortalCherryPickSHAs() {
        ArrayList<String> portalCherryPickSHAs = new ArrayList<String>();
        Object buildData = this.getBuildData();
        Map<String, String> topLevelBuildParameters = buildData.getTopLevelBuildParameters();
        String portalCherryPickSHAsString = topLevelBuildParameters.get(_NAME_BUILD_PARAMETER_PORTAL_CHERRY_PICK_SHAS);
        if (JenkinsResultsParserUtil.isNullOrEmpty(portalCherryPickSHAsString)) {
            return portalCherryPickSHAs;
        }
        for (String portalCherryPickSHA : portalCherryPickSHAsString.split(",")) {
            portalCherryPickSHAs.add(portalCherryPickSHA.trim());
        }
        return portalCherryPickSHAs;
    }
}

