/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitRepositoryJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class QAWebsitesGitRepositoryJob
extends GitRepositoryJob
implements PortalTestClassJob,
TestSuiteJob {
    private final List<String> _projectNames;
    private final String _testSuiteName;
    private final String _upstreamBranchName;

    @Override
    public String getBranchName() {
        return this._upstreamBranchName;
    }

    @Override
    public Set<String> getDistTypes() {
        return new HashSet<String>();
    }

    @Override
    public GitWorkingDirectory getGitWorkingDirectory() {
        return this.gitWorkingDirectory;
    }

    @Override
    public PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        return GitWorkingDirectoryFactory.newPortalGitWorkingDirectory("master");
    }

    public List<String> getProjectNames() {
        return this._projectNames;
    }

    @Override
    public String getTestSuiteName() {
        return this._testSuiteName;
    }

    protected QAWebsitesGitRepositoryJob(String jobName, Job.BuildProfile buildProfile, String testSuiteName, String upstreamBranchName, List<String> projectNames) {
        super(jobName, buildProfile);
        this._testSuiteName = testSuiteName;
        this._upstreamBranchName = upstreamBranchName;
        this._projectNames = projectNames;
        this.gitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(this._upstreamBranchName, this._getQAWebsitesGitRepositoryDir(), this._getQAWebsitesRepositoryName());
        this.setGitRepositoryDir(this.gitWorkingDirectory.getWorkingDirectory());
        this.checkGitRepositoryDir();
        this.jobPropertiesFiles.add(new File(this.gitRepositoryDir, "test.properties"));
        this.readJobProperties();
    }

    @Override
    protected Set<String> getRawBatchNames() {
        return this.getSetFromString(JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.names"));
    }

    private File _getQAWebsitesGitRepositoryDir() {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        String qaWebsitesDirPath = JenkinsResultsParserUtil.getProperty(buildProperties, "qa.websites.dir", this.getBranchName());
        if (JenkinsResultsParserUtil.isNullOrEmpty(qaWebsitesDirPath)) {
            throw new RuntimeException("Unable to find QA Websites directory path");
        }
        File qaWebsitesDir = new File(qaWebsitesDirPath);
        if (!qaWebsitesDir.exists()) {
            throw new RuntimeException("Unable to find QA Websites directory");
        }
        return qaWebsitesDir;
    }

    private String _getQAWebsitesRepositoryName() {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        String qaWebsitesRepository = JenkinsResultsParserUtil.getProperty(buildProperties, "qa.websites.repository", this.getBranchName());
        if (JenkinsResultsParserUtil.isNullOrEmpty(qaWebsitesRepository)) {
            throw new RuntimeException("Unable to find QA Websites repository");
        }
        return qaWebsitesRepository;
    }
}

