/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.JobFactory;
import com.liferay.jenkins.results.parser.PortalTopLevelBuild;
import com.liferay.jenkins.results.parser.PullRequest;
import com.liferay.jenkins.results.parser.PullRequestBuild;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.dom4j.Element;

public class PullRequestPortalTopLevelBuild
extends PortalTopLevelBuild
implements PullRequestBuild {
    private final PullRequest _pullRequest;
    private Job _stableJob;
    private String _stableJobResult;

    public PullRequestPortalTopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
        this.setCompareToUpstream(true);
        try {
            String testSuiteName = this.getTestSuiteName();
            if (testSuiteName.equals("relevant")) {
                this._stableJob = JobFactory.newJob(this.jobName, "stable", this.branchName);
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to create stable job for " + this.jobName);
            exception.printStackTrace();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("https://github.com/");
        sb.append(this.getParameterValue("GITHUB_RECEIVER_USERNAME"));
        sb.append("/liferay-portal");
        String branchName = this.getBranchName();
        if (!branchName.equals("master")) {
            sb.append("-ee");
        }
        sb.append("/pull/");
        sb.append(this.getParameterValue("GITHUB_PULL_REQUEST_NUMBER"));
        this._pullRequest = new PullRequest(sb.toString());
    }

    @Override
    public PullRequest getPullRequest() {
        return this._pullRequest;
    }

    @Override
    public String getResult() {
        Properties buildProperties;
        String result = super.getResult();
        List<Build> downstreamBuildFailures = this.getFailedDownstreamBuilds();
        if (result == null || downstreamBuildFailures.isEmpty()) {
            return result;
        }
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build properties", ioException);
        }
        boolean pullRequestForwardUpstreamFailureComparisonEnabled = Boolean.parseBoolean(buildProperties.getProperty("pull.request.forward.upstream.failure.comparison.enabled"));
        if (!pullRequestForwardUpstreamFailureComparisonEnabled || !this.isCompareToUpstream()) {
            return result;
        }
        String testSuiteName = this.getTestSuiteName();
        if (!testSuiteName.matches("relevant|stable")) {
            return result;
        }
        String batchWhitelist = buildProperties.getProperty("pull.request.forward.upstream.failure.comparison.batch.whitelist");
        List<String> whitelistedBatchRegexes = Arrays.asList(batchWhitelist.split("\\s*,\\s*"));
        for (Build downstreamBuild : downstreamBuildFailures) {
            if (downstreamBuild.isUniqueFailure()) {
                return result;
            }
            boolean approved = false;
            String jobVariant = downstreamBuild.getJobVariant();
            jobVariant = jobVariant.replaceAll("(.*)/.*", "$1");
            for (String whiteListedBatchRegex : whitelistedBatchRegexes) {
                if (!jobVariant.matches(".*" + whiteListedBatchRegex + ".*")) continue;
                approved = true;
                break;
            }
            if (approved) continue;
            return result;
        }
        return "APPROVED";
    }

    public String getStableJobResult() {
        if (this._stableJob == null) {
            return null;
        }
        if (this._stableJobResult != null) {
            return this._stableJobResult;
        }
        List<Build> stableJobDownstreamBuilds = this.getStableJobDownstreamBuilds();
        int stableJobDownstreamBuildsSize = stableJobDownstreamBuilds.size();
        if (stableJobDownstreamBuildsSize == 0) {
            return null;
        }
        ArrayList<String> stableJobBatchNames = new ArrayList<String>(this._stableJob.getBatchNames());
        int stableJobDownstreamBuildsCompletedCount = this.getJobVariantsDownstreamBuildCount(stableJobBatchNames, null, "completed");
        if (stableJobDownstreamBuildsCompletedCount != stableJobDownstreamBuildsSize) {
            return null;
        }
        String result = this.getResult();
        int stableJobDownstreamBuildsSuccessCount = this.getJobVariantsDownstreamBuildCount(stableJobBatchNames, "SUCCESS", null);
        this._stableJobResult = result != null && result.matches("(APPROVED|SUCCESS)") || stableJobDownstreamBuildsSuccessCount == stableJobDownstreamBuildsSize ? "SUCCESS" : "FAILURE";
        return this._stableJobResult;
    }

    @Override
    public boolean isUniqueFailure() {
        List<Build> failedDownstreamBuilds = this.getFailedDownstreamBuilds();
        for (Build downstreamBuild : failedDownstreamBuilds) {
            if (!downstreamBuild.isUniqueFailure()) continue;
            return true;
        }
        return failedDownstreamBuilds.isEmpty();
    }

    protected Element getFailedStableJobSummaryElement() {
        ArrayList<String> stableJobBatchNames = new ArrayList<String>(this._stableJob.getBatchNames());
        Element jobSummaryListElement = this.getJobSummaryListElement(false, stableJobBatchNames);
        int stableJobDownstreamBuildsSuccessCount = this.getJobVariantsDownstreamBuildCount(stableJobBatchNames, "SUCCESS", null);
        int stableJobDownstreamBuildsCount = this.getJobVariantsDownstreamBuildCount(stableJobBatchNames, null, null);
        int stableJobDownstreamBuildsFailureCount = stableJobDownstreamBuildsCount - stableJobDownstreamBuildsSuccessCount;
        return Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewElement("h4", null, String.valueOf(stableJobDownstreamBuildsFailureCount), " Failed Jobs:"), jobSummaryListElement);
    }

    protected List<Build> getStableJobDownstreamBuilds() {
        if (this._stableJob != null) {
            return this.getJobVariantsDownstreamBuilds(this._stableJob.getBatchNames(), null, null);
        }
        return Collections.emptyList();
    }

    protected Element getStableJobResultElement() {
        if (this._stableJob == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String stableJobResult = this.getStableJobResult();
        if (stableJobResult.equals("SUCCESS")) {
            sb.append(":heavy_check_mark: ");
        } else {
            sb.append(":x: ");
        }
        sb.append("ci:test:stable - ");
        sb.append(this.getJobVariantsDownstreamBuildCount(new ArrayList<String>(this._stableJob.getBatchNames()), "SUCCESS", null));
        sb.append(" out of ");
        List<Build> stableJobDownstreamBuilds = this.getStableJobDownstreamBuilds();
        sb.append(stableJobDownstreamBuilds.size());
        sb.append(" jobs passed");
        return Dom4JUtil.getNewElement("h3", null, sb.toString());
    }

    protected Element getStableJobSuccessSummaryElement() {
        ArrayList<String> stableJobBatchNames = new ArrayList<String>(this._stableJob.getBatchNames());
        Element stableJobSummaryListElement = this.getJobSummaryListElement(true, stableJobBatchNames);
        int stableJobDownstreamBuildsSuccessCount = this.getJobVariantsDownstreamBuildCount(stableJobBatchNames, "SUCCESS", null);
        return Dom4JUtil.getNewElement("details", null, Dom4JUtil.getNewElement("summary", null, Dom4JUtil.getNewElement("strong", null, String.valueOf(stableJobDownstreamBuildsSuccessCount), " Successful Jobs:")), stableJobSummaryListElement);
    }

    protected Element getStableJobSummaryElement() {
        ArrayList<String> stableJobBatchNames = new ArrayList<String>(this._stableJob.getBatchNames());
        int stableJobDownstreamBuildSuccessCount = this.getJobVariantsDownstreamBuildCount(stableJobBatchNames, "SUCCESS", null);
        List<Build> stableJobDownstreamBuilds = this.getStableJobDownstreamBuilds();
        Element detailsElement = Dom4JUtil.getNewElement("details", null, Dom4JUtil.getNewElement("summary", null, Dom4JUtil.getNewElement("strong", null, "ci:test:stable - ", String.valueOf(stableJobDownstreamBuildSuccessCount), " out of ", String.valueOf(stableJobDownstreamBuilds.size()), " jobs PASSED")));
        int stableJobDownstreamBuildCount = this.getJobVariantsDownstreamBuildCount(stableJobBatchNames, null, null);
        if (stableJobDownstreamBuildSuccessCount < stableJobDownstreamBuildCount) {
            Dom4JUtil.addToElement(detailsElement, this.getFailedStableJobSummaryElement());
        }
        if (stableJobDownstreamBuildSuccessCount > 0) {
            Dom4JUtil.addToElement(detailsElement, this.getStableJobSuccessSummaryElement());
        }
        return detailsElement;
    }

    @Override
    protected Element getTopGitHubMessageElement() {
        Element rootElement = super.getTopGitHubMessageElement();
        ArrayList<Build> stableJobDownstreamBuilds = new ArrayList<Build>();
        if (this._stableJob != null) {
            stableJobDownstreamBuilds.addAll(this.getStableJobDownstreamBuilds());
        }
        if (!stableJobDownstreamBuilds.isEmpty()) {
            Dom4JUtil.insertElementAfter(rootElement, null, this.getStableJobResultElement());
        }
        Element detailsElement = rootElement.element("details");
        if (!stableJobDownstreamBuilds.isEmpty()) {
            Element jobSummaryElement = detailsElement.element("details");
            Dom4JUtil.insertElementBefore(detailsElement, jobSummaryElement, this.getStableJobSummaryElement());
        }
        return rootElement;
    }
}

