/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PluginsTopLevelBuild;
import com.liferay.jenkins.results.parser.PullRequest;
import com.liferay.jenkins.results.parser.PullRequestBuild;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PullRequestPluginsTopLevelBuild
extends PluginsTopLevelBuild
implements PullRequestBuild {
    private static final Pattern _pattern = Pattern.compile("[^/]*functional[^/]*/(?<pluginName>[^/]+)/\\d+");
    private final PullRequest _pullRequest;

    public PullRequestPluginsTopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
        StringBuilder sb = new StringBuilder();
        sb.append("https://github.com/");
        sb.append(this.getParameterValue("GITHUB_RECEIVER_USERNAME"));
        sb.append("/liferay-plugins");
        String branchName = this.getBranchName();
        if (!branchName.equals("master")) {
            sb.append("-ee");
        }
        sb.append("/pull/");
        sb.append(this.getParameterValue("GITHUB_PULL_REQUEST_NUMBER"));
        this._pullRequest = new PullRequest(sb.toString());
    }

    @Override
    public String getBranchName() {
        String jobName = this.getJobName();
        return jobName.substring(jobName.indexOf("(") + 1, jobName.indexOf(")"));
    }

    @Override
    public String getPluginName() {
        for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
            Matcher matcher;
            String jobVariant = downstreamBuild.getParameterValue("JOB_VARIANT");
            if (jobVariant == null || !(matcher = _pattern.matcher(jobVariant)).find()) continue;
            return matcher.group("pluginName");
        }
        return null;
    }

    @Override
    public PullRequest getPullRequest() {
        return this._pullRequest;
    }

    @Override
    public String getTestSuiteName() {
        String ciTestSuite = this.getParameterValue("CI_TEST_SUITE");
        if (JenkinsResultsParserUtil.isNullOrEmpty(ciTestSuite)) {
            ciTestSuite = "default";
        }
        return ciTestSuite;
    }
}

