/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BatchDependentJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitRepositoryJob;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.SegmentTestClassGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class PortalUpstreamJob
extends PortalGitRepositoryJob
implements BatchDependentJob {
    public PortalUpstreamJob(String jobName, Job.BuildProfile buildProfile) {
        super(jobName, buildProfile);
        GitWorkingDirectory jenkinsGitWorkingDirectory = GitWorkingDirectoryFactory.newJenkinsGitWorkingDirectory();
        this.jobPropertiesFiles.add(new File(jenkinsGitWorkingDirectory.getWorkingDirectory(), "commands/dependencies/test-upstream-batch.properties"));
        this.readJobProperties();
    }

    @Override
    public List<AxisTestClassGroup> getDependentAxisTestClassGroups() {
        ArrayList<AxisTestClassGroup> axisTestClassGroups = new ArrayList<AxisTestClassGroup>();
        for (BatchTestClassGroup batchTestClassGroup : this.getDependentBatchTestClassGroups()) {
            axisTestClassGroups.addAll(batchTestClassGroup.getAxisTestClassGroups());
        }
        return axisTestClassGroups;
    }

    @Override
    public Set<String> getDependentBatchNames() {
        return this.getFilteredBatchNames(this.getRawDependentBatchNames());
    }

    @Override
    public List<BatchTestClassGroup> getDependentBatchTestClassGroups() {
        return this.getBatchTestClassGroups(this.getRawDependentBatchNames());
    }

    @Override
    public Set<String> getDependentSegmentNames() {
        return this.getFilteredSegmentNames(this.getRawDependentBatchNames());
    }

    @Override
    public List<SegmentTestClassGroup> getDependentSegmentTestClassGroups() {
        return this.getSegmentTestClassGroups(this.getRawDependentBatchNames());
    }

    @Override
    protected Set<String> getRawBatchNames() {
        return this.getSetFromString(JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.names[portal-upstream(" + this.getBranchName() + ")]"));
    }

    protected Set<String> getRawDependentBatchNames() {
        return this.getSetFromString(JenkinsResultsParserUtil.getProperty(this.getJobProperties(), "test.batch.names.smoke[" + this.getBranchName() + "]"));
    }
}

