/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalRelease;
import com.liferay.jenkins.results.parser.PortalTopLevelBuild;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PortalReleasePortalTopLevelBuild
extends PortalTopLevelBuild {
    private static final Pattern _pattern = Pattern.compile("(?<major>\\d)\\.(?<minor>\\d)\\.(?<fix>\\d+)");
    private PortalRelease _portalRelease;

    public PortalReleasePortalTopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    public String getBaseGitRepositoryName() {
        return "liferay-portal-ee";
    }

    @Override
    public String getBranchName() {
        String portalBranchName = this.getParameterValue("TEST_PORTAL_BRANCH_NAME");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(portalBranchName)) {
            return portalBranchName;
        }
        PortalRelease portalRelease = this.getPortalRelease();
        String portalVersion = portalRelease.getPortalVersion();
        Matcher matcher = _pattern.matcher(portalVersion);
        if (!matcher.find()) {
            throw new RuntimeException("Invalid portal version: " + portalVersion);
        }
        return JenkinsResultsParserUtil.combine(matcher.group("major"), ".", matcher.group("minor"), ".x");
    }

    @Override
    public PortalRelease getPortalRelease() {
        if (this._portalRelease != null) {
            return this._portalRelease;
        }
        try {
            URL portalReleaseTomcatURL = new URL(this.getParameterValue("TEST_PORTAL_RELEASE_TOMCAT_URL"));
            this._portalRelease = new PortalRelease(portalReleaseTomcatURL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        return this._portalRelease;
    }
}

